/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "ProgressBar.h"
#include "DT_drawtext.h"
#include "Config.h"

ProgressBar::ProgressBar(SDL_Surface* screen){
	data_count = 0;
	step = 0;
	step_width = 0;
	this->screen = screen;
	picture = load_image(ADD_IMG_PATH("general/progress_bar.jpg"),NO_TRANSPARENT);
	font = load_image(ADD_IMG_PATH("general/console_font.png"),TRANSPARENT);
	if(-1 == (font_id = DT_InitFont(font, TRANS_FONT))){
		fprintf(stderr,"Could not init progressbar font\n");
	}
	
	rect.x = (Config::get_screen_w() - picture->w ) / 2;
	rect.y = Config::get_screen_h() - picture->h - font->h - ((Config::get_screen_h() - 600 ) / 2);
	rect.w = picture->w;
	rect.h = picture->h + font->h;
	SDL_SetClipRect(screen,&rect);
}
  
ProgressBar::~ProgressBar(){
	SDL_FreeSurface(picture);
	SDL_FreeSurface(font);
	SDL_FreeSurface(back_screen);
}

void ProgressBar::draw_next_step(char* filename){
	if(data_count<1) return;
	step++;

	SDL_Rect s,d;
	s.x = 0;
	s.y = 0;
	s.w = step*step_width;
	s.h = picture->h;
	d.x = (Config::get_screen_w() - picture->w ) / 2;
	d.y = screen->h - picture->h - ((Config::get_screen_h() - 600 ) / 2);
	d.w = s.w;
	d.h = s.h;
	BlitSurface(picture,&s,screen,&d);
	
	char str[256];
	sprintf(str,"Loading (%s) : %i%%\n",filename, MIN(((step*100)/data_count),100));
	static int str_len=0;
	
	s.x = rect.x+5;
	s.y = rect.y;
	s.w = str_len*DT_FontWidth(font_id)*2;
	s.h = DT_FontHeight(font_id);
	BlitSurface(back_screen,&s,screen,&s);
	DT_DrawText(str, screen, font_id, s.x, s.y );
	str_len = strlen(str);
	
	SDL_Flip(screen);
}


void ProgressBar::set_data_count(int i){
	back_screen = SDL_ConvertSurface(screen, screen->format, screen->flags);
    data_count = i;
	if(data_count<1) return;
	SDL_SetClipRect(screen,&rect);
	step = -1;
	step_width = rect.w / data_count;
}

SDL_Surface* ProgressBar::load_image(char *datafile, int transparent){
  SDL_Surface *image;
  image = IMG_Load(datafile);
  if ( image == NULL ) {
    fprintf(stderr, "Couldn't load image %s: %s\n",datafile, IMG_GetError());
    return NULL;
  }
   
  if ( transparent ) {
    /* Assuming 8-bit BMP image */
    SDL_SetColorKey(image, (SDL_SRCCOLORKEY|SDL_RLEACCEL),*(Uint8 *)image->pixels);
  }
  
  SDL_Surface *r =  SDL_DisplayFormat(image);
  SDL_FreeSurface(image);

  return r;
}
