/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2002 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef NOSOUND

#ifndef SOUNDPLAYER_H
#define SOUNDPLAYER_H

#include "global.h"
#include "sounds.h"

#include <smpeg/smpeg.h>

#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>

class SoundPlayer{
 public:
  SoundPlayer(void);
  ~SoundPlayer(void);
  void play_sound(int,int);
  void play_sound(int);
  void stop_sound(int);
  void loop_sound(int,int);
  void loop_sound(int);
  void play_music(int);
  void pause_music(int);
  void stop_music(int);
  void stop_sound(void);
  void set_volume(int);
  void toggle_play_pause(int);
  void toggle_play_pause(int,bool);
  void dec_volume(void);
  void inc_volume(void);
  void set_enabled(bool);
  SDL_AudioSpec get_audiospec(void);
  int get_current_music(void);
 private:
	void add_sound(const char*,int);
	void remove_sound(int);
	void add_music(const char*,int);
	void remove_music(int);
 
	SMPEG *music[(NUM_MUSICS==0)?1:(NUM_MUSICS)];
	Mix_Chunk * sounds[NUM_SOUNDS];
	SMPEG_Info info;
	
	SDL_AudioSpec audiofmt;
    Uint16 format;
    int freq, channels;
	int buffers;
	int volume;
	bool enable;
	bool audio_opened;
	int current_music;
};

#endif


#else
;
#endif









