/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef STATE_H
#define STATE_H

#include "global.h"
#include "Square.h"
#include "Player.h"
#include "Team.h"
#include "Public.h"
#include "Ball.h"

class State {
	public:
	State();
	~State();
	void init();
	void save_state(FILE *, int);

	bool kick_off_anim;
	int old_formation_id;
	int reserve_nav_alpha[2][2];
	int actions_menu_items[ACTIONS_NB];
	int actions_menu_items_state[ACTIONS_NB];
	bool actions_menu_throw_team_mate;
	bool actions_menu_leap;
	bool debug;
	bool dices_roll;
	int actions_menu_transparency;
	Ball *ball;
	int frame;
	Square *selection, *old_selected_player,*location_square;
	Player *selected_player,*player_to_place;
	int player_to_place_x,player_to_place_y;
	int tackle_zone_drawing_mode;
	bool ticks_drawing_mode;
	bool grab_mouse_mode;
	bool number_drawing_mode;
	contextual_info_t *contextual_info;
	int current_action;
	int current_mode;
	Team *team[2];
	Public *audience;
	Path *path;
	bool player_is_moving;
	Square *target;
	int x_menu_clic;
	int y_menu_clic;
	int x_player_clic;
	int y_player_clic;
	bool zoom_mode;
	bool autocenter_mode;
	bool freeze_interaction;
	bool select_throw_target;
	int x_push;
	int y_push;
	Square *push_square;
	Square* push_squares[MAX_PUSH_SQUARE];
	int push_square_count;
	bool direct_push;
	int x_indirect_push;
	int y_indirect_push;
	Square* indirect_push_square;
	Square* indirect_push_squares[MAX_PUSH_SQUARE];
	int indirect_push_square_count;
	bool direct_indirect_push;
	
	int x_double_indirect_push;
	int y_double_indirect_push;
	Square* double_indirect_push_square;
	Square* double_indirect_push_squares[MAX_PUSH_SQUARE];
	int double_indirect_push_square_count;
	bool direct_double_indirect_push;
	
	int old_x_square;
	int old_y_square;
	bool throw_in_anim;
	int active_team;
	int old_active_team;
	Uint32 turn_begining_time,pause_begining_time;
	bool autocenter_anim;
	bool pass_anim;
	bool target_anim;
	bool perfect_pass;
	Square* interception_squares[MAX_PLAYER_ON_PLAYGROUND];
	Square* interception_square;
	int interception_square_count;
	bool interception_attempt;
	int x_dock,y_dock;
	bool drag_dock;
	bool drag_playground;
	bool pause;
	bool update_time;
	int remaining_time;
	int max_victims;
	int old_ball_owner_team;
	Square* transmit_squares[MAX_NEIGHBOUR];
	Square* transmit_square;
	int transmit_square_count;
	bool pass_arrow_matrix[PASS_ARROW_MATRIX_MAX_SIZE][PASS_ARROW_MATRIX_MAX_SIZE];
	int pass_arrow_matrix_w;
	int pass_arrow_matrix_h;
	int reserve_page[2];
	int reserve_page_count[2];
	int corridor_count[2][2];
	int kick_off_result;
	int kick_off_team;
	int first_half_kick_off_team;
	int team_in_placement;
	int half;
	Uint32 t0;
	int weather;
	Player *team_mate;
	bool throw_team_mate_anim;
	bool throw_team_mate_fumble;
	///////////////////////////////////
	// Ragnar Modif : nouvelles variables
	bool freeze_time;
	bool is_a_dump_off;
	bool is_a_blitz_dump_off;
	Square *selection_save;
	Player *player_save;
	///////////////////////////////////
	// Ragnar Modif3 : pour crasement
	bool is_a_skull_and_star;
	///////////////////////////////////
	// Ragnar Modif4 : pour trancher en cas de nul aprs prolongations
	bool need_a_winner;
	///////////////////////////////////
};

#endif

