/*******************************************************************************
 * Copyright (c) Contributors to the Eclipse Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0 
 *******************************************************************************/

package org.osgi.service.enocean.descriptions;

/**
 * Subinterface of {@link EnOceanChannelDescription} that describes enumerated
 * channels.
 * 
 * @version 1.0
 * @author $Id: 07437df42131bfcd8970e4cb65f1820e3ae7f96d $
 */
public interface EnOceanEnumChannelDescription extends EnOceanChannelDescription {

    /**
     * Gets all the possible value for this channel.
     * 
     * @return corresponding value(s).
     */
    public EnOceanChannelEnumValue[] getPossibleValues();

}
