/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.internal.artifacts.ComponentResolversFactory;
import org.gradle.api.internal.artifacts.GlobalDependencyResolutionRules;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResolveIvyFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResolverProviderFactory;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolversChain;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.resolve.caching.ComponentMetadataSupplierRuleExecutor;

public class DefaultComponentResolversFactory
implements ComponentResolversFactory {
    private final List<ResolverProviderFactory> resolverFactories;
    private final ResolveIvyFactory moduleDependencyResolverFactory;
    private final ProjectDependencyResolver projectDependencyResolver;
    private final ImmutableAttributesFactory attributesFactory;
    private final ComponentMetadataSupplierRuleExecutor componentMetadataSupplierRuleExecutor;
    private final GlobalDependencyResolutionRules metadataHandler;

    @Inject
    public DefaultComponentResolversFactory(List<ResolverProviderFactory> resolverFactories, ResolveIvyFactory moduleDependencyResolverFactory, ProjectDependencyResolver projectDependencyResolver, ImmutableAttributesFactory attributesFactory, ComponentMetadataSupplierRuleExecutor componentMetadataSupplierRuleExecutor, GlobalDependencyResolutionRules metadataHandler) {
        this.resolverFactories = resolverFactories;
        this.moduleDependencyResolverFactory = moduleDependencyResolverFactory;
        this.projectDependencyResolver = projectDependencyResolver;
        this.attributesFactory = attributesFactory;
        this.componentMetadataSupplierRuleExecutor = componentMetadataSupplierRuleExecutor;
        this.metadataHandler = metadataHandler;
    }

    @Override
    public ComponentResolvers create(ResolveContext resolveContext, List<? extends ResolutionAwareRepository> repositories, AttributesSchemaInternal consumerSchema) {
        DefaultComponentResolversFactory.validateResolutionStrategy(resolveContext.getResolutionStrategy());
        ArrayList<ComponentResolvers> resolvers = new ArrayList<ComponentResolvers>(3);
        for (ResolverProviderFactory factory : this.resolverFactories) {
            factory.create(resolvers);
        }
        resolvers.add(this.projectDependencyResolver);
        resolvers.add(this.createModuleRepositoryResolvers(repositories, consumerSchema, resolveContext.getName(), resolveContext.getResolutionStrategy(), resolveContext.getAttributes(), this.metadataHandler));
        return new ComponentResolversChain(resolvers);
    }

    private static void validateResolutionStrategy(ResolutionStrategyInternal resolutionStrategy) {
        if (resolutionStrategy.isDependencyLockingEnabled()) {
            if (resolutionStrategy.isFailingOnDynamicVersions()) {
                DefaultComponentResolversFactory.failOnDependencyLockingConflictingWith("fail on dynamic versions");
            } else if (resolutionStrategy.isFailingOnChangingVersions()) {
                DefaultComponentResolversFactory.failOnDependencyLockingConflictingWith("fail on changing versions");
            }
        }
    }

    private static void failOnDependencyLockingConflictingWith(String conflicting) {
        throw new InvalidUserCodeException("Resolution strategy has both dependency locking and " + conflicting + " enabled. You must choose between the two modes.");
    }

    private ComponentResolvers createModuleRepositoryResolvers(List<? extends ResolutionAwareRepository> repositories, AttributesSchemaInternal consumerSchema, String resolveContextName, ResolutionStrategyInternal resolutionStrategy, AttributeContainerInternal requestedAttributes, GlobalDependencyResolutionRules metadataHandler) {
        return this.moduleDependencyResolverFactory.create(resolveContextName, resolutionStrategy, repositories, metadataHandler.getComponentMetadataProcessorFactory(), (AttributeContainer)requestedAttributes, (AttributesSchema)consumerSchema, this.attributesFactory, this.componentMetadataSupplierRuleExecutor);
    }
}

