/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collections;

import java.util.AbstractList;
import java.util.BitSet;
import java.util.List;
import org.gradle.api.specs.Spec;

public class ImmutableFilteredList<T>
extends AbstractList<T> {
    private final List<T> source;
    private final BitSet filter;

    private ImmutableFilteredList(List<T> source, BitSet filter) {
        this.source = source;
        this.filter = filter;
    }

    public static <T> ImmutableFilteredList<T> allOf(List<T> source) {
        BitSet filter = new BitSet(source.size());
        filter.set(0, source.size());
        return new ImmutableFilteredList<T>(source, filter);
    }

    public ImmutableFilteredList<T> withoutIndexFrom(int index, ImmutableFilteredList<T> other) {
        assert (other.source == this.source);
        BitSet newFilter = new BitSet(this.source.size());
        newFilter.or(this.filter);
        newFilter.clear(super.getSourceIndex(index));
        return new ImmutableFilteredList<T>(this.source, newFilter);
    }

    public ImmutableFilteredList<T> matching(Spec<T> matcher) {
        BitSet newFilter = new BitSet(this.source.size());
        int actual = this.filter.nextSetBit(0);
        while (actual >= 0) {
            if (matcher.isSatisfiedBy(this.source.get(actual))) {
                newFilter.set(actual);
            }
            actual = this.filter.nextSetBit(actual + 1);
        }
        return new ImmutableFilteredList<T>(this.source, newFilter);
    }

    @Override
    public T get(int index) {
        return this.source.get(this.getSourceIndex(index));
    }

    @Override
    public int size() {
        return this.filter.cardinality();
    }

    private int getSourceIndex(int index) {
        int actual = this.filter.nextSetBit(0);
        for (int i = 0; i < index; ++i) {
            actual = this.filter.nextSetBit(actual + 1);
        }
        return actual;
    }
}

