/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui;

import javax.microedition.lcdui.Canvas;
import net.yura.mobile.gui.Midlet;

public class KeyEvent {
    public static final int MIN_INPUT_VALUE = 9;
    public static final int KEY_SOFTKEY1 = -6;
    public static final int KEY_SOFTKEY2 = -7;
    public static final int KEY_SOFTKEY3 = -5;
    public static final int KEY_CLEAR = -8;
    public static final int KEY_DELETE = -9;
    public static final int KEY_CALL = -10;
    public static final int KEY_END = -11;
    public static final int KEY_MENU = -12;
    public static final int KEY_EDIT = -50;
    private Canvas canvas;
    private int justPressedKey;
    private int justReleasedKey;
    private int[] isDownKeys = new int[1];
    private int pos;
    private boolean acc;
    private boolean old;
    private int lastGotCode;
    public static boolean BLACKBERRY_ITUT = false;
    private static final String CHARS_PHONE = "*+pw";
    private static final String CHARS_DECIMAL = ".-";
    private static final String CHARS_35 = " ";
    private static final String CHARS_42 = "*#";
    private static final String CHARS_48 = Midlet.getPlatform() == 3 ? "0+" : " 0";
    private static final String CHARS_49 = ".,?!1@'-_():;&/%";
    private static final String CHARS_50 = "abc2";
    private static final String CHARS_51 = "def3";
    private static final String CHARS_52 = "ghi4";
    private static final String CHARS_53 = "jkl5";
    private static final String CHARS_54 = "mno6";
    private static final String CHARS_55 = "pqrs7";
    private static final String CHARS_56 = "tuv8";
    private static final String CHARS_57 = "wxyz9";

    public boolean acceptNew() {
        return this.acc;
    }

    public boolean acceptOld() {
        return this.old;
    }

    public char getKeyChar(int code, String cha, boolean accepted) {
        this.old = !accepted && this.lastGotCode != code;
        this.lastGotCode = code;
        if (cha == null) {
            return '\u0000';
        }
        if (code == 48 && Midlet.getPlatform() == 3) {
            this.acc = this.pos == -1;
            boolean bl = this.old = this.pos >= 0;
            return (char)(this.pos >= 0 ? 48 : (this.pos == -1 ? 43 : 0));
        }
        if (this.pos == -1) {
            this.acc = true;
            return (char)code;
        }
        if (this.pos == -2 && cha.length() != 1) {
            return '\u0000';
        }
        if (accepted) {
            this.pos = 0;
        }
        this.acc = cha.length() == 1;
        return cha.charAt(this.pos % cha.length());
    }

    public static String getChars(char keycode, int constraints) {
        if ((constraints & 0xFFFF) == 2) {
            if (keycode >= '0' && keycode <= '9') {
                return String.valueOf(keycode);
            }
            return null;
        }
        if ((constraints & 0xFFFF) == 5) {
            if (keycode >= '0' && keycode <= '9' || CHARS_DECIMAL.indexOf(keycode) != -1) {
                return String.valueOf(keycode);
            }
            if (keycode == '*') {
                return String.valueOf(CHARS_DECIMAL.charAt(0));
            }
            if (keycode == '#') {
                return String.valueOf(CHARS_DECIMAL.charAt(1));
            }
            return null;
        }
        if ((constraints & 0xFFFF) == 3) {
            if (keycode >= '0' && keycode <= '9' || keycode == '#') {
                return String.valueOf(keycode);
            }
            if (keycode == '*') {
                return CHARS_PHONE;
            }
            if (CHARS_PHONE.indexOf(keycode) != -1) {
                return String.valueOf(keycode);
            }
            return null;
        }
        switch (keycode) {
            case '#': {
                return CHARS_35;
            }
            case '*': {
                return CHARS_42;
            }
            case '0': {
                return CHARS_48;
            }
            case '1': {
                return CHARS_49;
            }
            case '2': {
                return CHARS_50;
            }
            case '3': {
                return CHARS_51;
            }
            case '4': {
                return CHARS_52;
            }
            case '5': {
                return CHARS_53;
            }
            case '6': {
                return CHARS_54;
            }
            case '7': {
                return CHARS_55;
            }
            case '8': {
                return CHARS_56;
            }
            case '9': {
                return CHARS_57;
            }
        }
        return String.valueOf(keycode);
    }

    public KeyEvent(Canvas c) {
        this.canvas = c;
    }

    public int getJustPressedKey() {
        return this.justPressedKey;
    }

    public int getJustReleasedKey() {
        return this.justReleasedKey;
    }

    public int getIsDownKey() {
        for (int c = this.isDownKeys.length - 1; c >= 0; --c) {
            if (this.isDownKeys[c] == 0) continue;
            return this.isDownKeys[c];
        }
        return 0;
    }

    public int getIsDownAction() {
        for (int c = this.isDownKeys.length - 1; c >= 0; --c) {
            int action;
            if (this.isDownKeys[c] == 0 || (action = this.getKeyAction(this.isDownKeys[c])) == 0) continue;
            return action;
        }
        return 0;
    }

    public String getKeyText(int keyCode) {
        keyCode = this.checkBack(keyCode);
        try {
            return this.canvas.getKeyName(keyCode);
        }
        catch (Throwable ex) {
            return ex.getMessage();
        }
    }

    public int getKeyAction(int code) {
        code = this.checkBack(code);
        try {
            return this.canvas.getGameAction(code);
        }
        catch (Throwable ex) {
            return 0;
        }
    }

    public boolean isDownAction(int action) {
        for (int c = 0; c < this.isDownKeys.length; ++c) {
            if (this.isDownKeys[c] == 0 || this.getKeyAction(this.isDownKeys[c]) != action) continue;
            return true;
        }
        return false;
    }

    public boolean justPressedAction(int action) {
        return this.justPressedKey != 0 && this.getKeyAction(this.justPressedKey) == action;
    }

    public boolean justReleasedAction(int action) {
        return this.justReleasedKey != 0 && this.getKeyAction(this.justReleasedKey) == action;
    }

    public boolean isDownKey(int key) {
        for (int c = 0; c < this.isDownKeys.length; ++c) {
            if (this.isDownKeys[c] != key) continue;
            return true;
        }
        return false;
    }

    public boolean justPressedKey(int key) {
        return this.justPressedKey == key;
    }

    public boolean justReleasedKey(int key) {
        return this.justReleasedKey == key;
    }

    public void keyPressed(int keyCode) {
        this.pos = this.justReleasedKey == (keyCode = this.check(keyCode)) ? ++this.pos : 0;
        this.justReleasedKey = 0;
        this.justPressedKey = keyCode;
        this.addKeyDown(keyCode);
    }

    public void keyReleased(int keyCode) {
        keyCode = this.check(keyCode);
        if (this.pos < 0) {
            this.pos = 0;
        }
        this.justPressedKey = 0;
        this.justReleasedKey = keyCode;
        this.removeKeyDown(keyCode);
    }

    public void keyRepeated(int keyCode) {
        this.pos = this.pos == -1 || this.pos == -2 ? -2 : -1;
        this.justReleasedKey = 0;
        this.justPressedKey = 0;
    }

    private void addKeyDown(int keyCode) {
        boolean found = false;
        for (int c = 0; c < this.isDownKeys.length; ++c) {
            if (this.isDownKeys[c] == 0 || this.isDownKeys[c] == keyCode) {
                found = true;
            }
            if (!found) continue;
            if (c == this.isDownKeys.length - 1) {
                this.isDownKeys[c] = keyCode;
                return;
            }
            this.isDownKeys[c] = this.isDownKeys[c + 1];
        }
        int[] newKeyDown = new int[this.isDownKeys.length + 1];
        System.arraycopy(this.isDownKeys, 0, newKeyDown, 0, this.isDownKeys.length);
        newKeyDown[this.isDownKeys.length] = keyCode;
        this.isDownKeys = newKeyDown;
    }

    private void removeKeyDown(int keyCode) {
        for (int c = 0; c < this.isDownKeys.length; ++c) {
            if (this.isDownKeys[c] != keyCode) continue;
            this.isDownKeys[c] = 0;
        }
    }

    public void clear() {
        this.justPressedKey = 0;
        this.justReleasedKey = 0;
        this.isDownKeys = new int[1];
    }

    private int check(int keyCode) {
        if (Midlet.getPlatform() == 11 && keyCode == -8) {
            return -5;
        }
        switch (keyCode) {
            case 8: {
                return -8;
            }
            case 127: {
                return -9;
            }
            case 13: {
                return 10;
            }
        }
        return keyCode;
    }

    private int checkBack(int code) {
        if (Midlet.getPlatform() == 11) {
            switch (code) {
                case -5: {
                    code = -8;
                    break;
                }
                case -8: {
                    code = 8;
                }
            }
        }
        return code;
    }

    public String toString() {
        StringBuffer string = new StringBuffer();
        string.append("KeyEvent justPressedKey=");
        string.append(String.valueOf(this.justPressedKey));
        string.append(" justReleasedKey=");
        string.append(String.valueOf(this.justReleasedKey));
        int[] copy = this.isDownKeys;
        if (copy != null) {
            string.append(" isDownKeys=[");
            for (int c = 0; c < copy.length; ++c) {
                string.append(String.valueOf(copy[c]));
                if (c >= copy.length - 1) continue;
                string.append(',');
            }
            string.append("]");
        }
        return string.toString();
    }
}

