/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class LongKeyLongValueHashMap
extends BaseHashMap
implements Map<Long, Long> {
    private Set<Long> keySet;
    private Collection<Long> values;
    private Set<Map.Entry<Long, Long>> entries;

    public LongKeyLongValueHashMap() {
        this(8);
    }

    public LongKeyLongValueHashMap(int n) throws IllegalArgumentException {
        super(n, 2, 2, false);
    }

    public LongKeyLongValueHashMap(boolean bl) {
        this(8);
        this.minimizeOnEmpty = bl;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Long) {
            long l = (Long)object;
            return super.containsLongKey(l);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean containsKey(long l) {
        return super.containsLongKey(l);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object instanceof Long) {
            long l = (Long)object;
            return super.containsValue(l);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(long l) {
        return super.containsValue(l);
    }

    @Override
    public Long get(Long l) {
        if (l == null) {
            throw new NullPointerException();
        }
        long l2 = l;
        int n = this.getLookup(l2);
        if (n != -1) {
            long l3 = this.longValueTable[n];
            return l3;
        }
        return null;
    }

    @Override
    public long get(long l) throws NoSuchElementException {
        int n = this.getLookup(l);
        if (n != -1) {
            return this.longValueTable[n];
        }
        throw new NoSuchElementException();
    }

    public long get(long l, long l2) {
        int n = this.getLookup(l);
        if (n != -1) {
            return this.longValueTable[n];
        }
        return l2;
    }

    public boolean get(long l, long[] lArray) {
        int n = this.getLookup(l);
        if (n != -1) {
            lArray[0] = this.longValueTable[n];
            return true;
        }
        return false;
    }

    @Override
    public Long put(Long l, Long l2) {
        if (l == null || l2 == null) {
            throw new NullPointerException();
        }
        int n = this.size();
        super.addOrUpdate(l, l2, null, null);
        if (n == this.size()) {
            return null;
        }
        return l2;
    }

    @Override
    public boolean put(long l, long l2) {
        int n = this.size();
        super.addOrUpdate(l, l2, null, null);
        return n != this.size();
    }

    @Override
    public Long remove(Object object) {
        if (object instanceof Long) {
            long l = (Long)object;
            return (Long)super.remove(l, 0L, null, null, false, false);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public boolean remove(long l) {
        Long l2 = (Long)super.remove(l, 0L, null, null, false, false);
        return l2 != null;
    }

    public void putAll(LongKeyLongValueHashMap longKeyLongValueHashMap) {
        Iterator iterator = longKeyLongValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            long l = iterator.nextLong();
            long l2 = longKeyLongValueHashMap.get(l);
            this.put(l, l2);
        }
    }

    public long[] keysToArray(long[] lArray) {
        return this.toLongArray(lArray, true);
    }

    public long[] valuesToArray(long[] lArray) {
        return this.toLongArray(lArray, false);
    }

    @Override
    public Set<Long> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<Long> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, Long>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values
    extends AbstractReadOnlyCollection<Long> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongKeyLongValueHashMap longKeyLongValueHashMap = LongKeyLongValueHashMap.this;
            longKeyLongValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyLongValueHashMap, false);
        }

        @Override
        public int size() {
            return LongKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet
    extends AbstractReadOnlyCollection<Long>
    implements Set<Long> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongKeyLongValueHashMap longKeyLongValueHashMap = LongKeyLongValueHashMap.this;
            longKeyLongValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyLongValueHashMap, true);
        }

        @Override
        public int size() {
            return LongKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(LongKeyLongValueHashMap.this, true);
        }

        @Override
        public Map.Entry<Long, Long> next() {
            Long l = super.nextLong();
            Long l2 = LongKeyLongValueHashMap.this.longValueTable[this.lookup];
            return new MapEntry<Long, Long>(l, l2);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Long, Long>>
    implements Set<Map.Entry<Long, Long>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, Long>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LongKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

