/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.ListScroller;
import com.impossibl.postgres.jdbc.PGResultSet;
import com.impossibl.postgres.protocol.DataRow;
import com.impossibl.postgres.protocol.QueryCommand;
import com.impossibl.postgres.protocol.ResultField;
import java.sql.SQLException;
import java.util.List;

class CommandScroller
extends ListScroller {
    PGResultSet resultSet;
    int resultsIndexOffset;
    QueryCommand command;

    CommandScroller(PGResultSet resultSet, QueryCommand command, List<ResultField> resultFields, List<DataRow> results) {
        super(resultFields, results, true);
        this.resultSet = resultSet;
        this.command = command;
    }

    @Override
    void close() throws SQLException {
        super.close();
        this.resultSet.statement.dispose(this.command);
    }

    @Override
    int getType() {
        return 1003;
    }

    @Override
    public int getRow() throws SQLException {
        if (!this.isValidRow()) {
            return 0;
        }
        return this.resultsIndexOffset + this.currentRowIndex + 1;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return super.isBeforeFirst() && this.resultsIndexOffset == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return super.isAfterLast() && this.command.getStatus() == QueryCommand.Status.Completed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return super.isFirst() && this.resultsIndexOffset == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return super.isLast() && this.command.getStatus() == QueryCommand.Status.Completed;
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }

    @Override
    public void afterLast() throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }

    @Override
    public boolean first() throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }

    @Override
    public boolean last() throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }

    @Override
    public boolean next() throws SQLException {
        if (Math.min(++this.currentRowIndex, this.results.size()) == this.results.size() && this.command != null && this.command.getStatus() != QueryCommand.Status.Completed) {
            if (this.resultSet.fetchSize != null) {
                this.command.setMaxRows(this.resultSet.fetchSize);
            }
            this.resultSet.warningChain = this.resultSet.statement.connection.execute(this.command, true);
            List<QueryCommand.ResultBatch> resultBatches = this.command.getResultBatches();
            if (resultBatches.size() != 1) {
                throw new SQLException("Invalid result data");
            }
            QueryCommand.ResultBatch resultBatch = resultBatches.get(0);
            this.resultFields = resultBatch.getFields();
            this.setResults(resultBatch.getResults());
            this.resultsIndexOffset += this.currentRowIndex;
            this.currentRowIndex = -1;
            return this.next();
        }
        return this.isValidRow();
    }

    @Override
    boolean previous() throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }
}

