/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Optional;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Preconditions;
import com.microsoft.applicationinsights.internal.channel.TelemetrySerializer;
import com.microsoft.applicationinsights.internal.channel.common.Transmission;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.zip.GZIPOutputStream;

public final class GzipTelemetrySerializer
implements TelemetrySerializer {
    private static final String GZIP_WEB_CONTENT_TYPE = "application/x-json-stream";
    private static final String GZIP_WEB_ENCODING_TYPE = "gzip";
    private final byte[] newlineString = System.getProperty("line.separator").getBytes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Transmission> serialize(Collection<String> telemetries) {
        Preconditions.checkNotNull(telemetries, "telemetries must be non-null value");
        Preconditions.checkArgument(!telemetries.isEmpty(), "telemetries: One or more telemetry item is expected");
        Transmission result = null;
        boolean succeeded = false;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try (GZIPOutputStream zipStream = new GZIPOutputStream(byteStream);){
                succeeded = this.compress(zipStream, telemetries);
                return Optional.fromNullable(result);
            }
            finally {
                byteStream.close();
                if (succeeded) {
                    result = new Transmission(byteStream.toByteArray(), GZIP_WEB_CONTENT_TYPE, GZIP_WEB_ENCODING_TYPE);
                }
            }
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to serialize , exception: %s", e.toString());
        }
        return Optional.fromNullable(result);
    }

    private boolean compress(GZIPOutputStream zipStream, Collection<String> telemetries) throws IOException {
        int counter = 0;
        StringWriter writer = new StringWriter();
        JsonTelemetryDataSerializer jsonWriter = new JsonTelemetryDataSerializer(writer);
        for (String telemetry : telemetries) {
            if (counter != 0) {
                zipStream.write(this.newlineString);
            }
            try {
                zipStream.write(telemetry.getBytes());
                ++counter;
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Failed to serialize , exception: %s", e.toString());
            }
            if (counter >= telemetries.size()) continue;
            writer.getBuffer().setLength(0);
            jsonWriter.reset(writer);
        }
        return counter > 0;
    }
}

