/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Preconditions;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.internal.config.TelemetryConfigurationFactory;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.HashSet;

public final class ConfigurationFileLocator {
    public static final String CONFIG_DIR_PROPERTY = "applicationinsights.configurationDirectory";
    private final String configurationFileName;

    public ConfigurationFileLocator(String configurationFileName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(configurationFileName), "configurationFile should be non-null non empty value");
        this.configurationFileName = configurationFileName;
    }

    public InputStream getConfigurationFile() {
        String configurationFile;
        String configDirFromProperty = System.getProperty(CONFIG_DIR_PROPERTY);
        if (configDirFromProperty != null) {
            configurationFile = this.getConfigurationAbsolutePath(configDirFromProperty);
        } else {
            InputStream inputStream = ConfigurationFileLocator.class.getClassLoader().getResourceAsStream(this.configurationFileName);
            if (inputStream != null) {
                InternalLogger.INSTANCE.info("Configuration file has been successfully found as resource", new Object[0]);
                return inputStream;
            }
            configurationFile = this.getConfigurationFromCurrentClassLoader();
            if (configurationFile == null && (configurationFile = this.getConfigurationFromLibraryLocation()) == null) {
                configurationFile = this.getConfFromClassPath();
            }
        }
        if (configurationFile != null) {
            InternalLogger.INSTANCE.info("Configuration file has been successfully found in: '%s'", configurationFile);
            try {
                return new FileInputStream(configurationFile);
            }
            catch (FileNotFoundException e) {
                InternalLogger.INSTANCE.warn("Configuration file '%s' could not be opened for reading, Exception : %s", configurationFile, ExceptionUtils.getStackTrace(e));
            }
        } else {
            InternalLogger.INSTANCE.error("Configuration file '%s' could not be found", this.configurationFileName);
        }
        return null;
    }

    private static void logException(Throwable t, String message) {
        if (t.getCause() != null) {
            InternalLogger.INSTANCE.warn("Failed to find configuration file, exception while fetching from %s: Exception : '%s'", message, ExceptionUtils.getStackTrace(t));
        } else {
            InternalLogger.INSTANCE.warn("Failed to find configuration file, exception while fetching from %s: Exception : '%s'", message, ExceptionUtils.getStackTrace(t));
        }
    }

    private String getConfigurationFromCurrentClassLoader() {
        try {
            File filePath;
            ClassLoader classLoader = ConfigurationFileLocator.class.getClassLoader();
            String configurationFile = null;
            URL resourceUrl = classLoader.getResource(this.configurationFileName);
            if (resourceUrl != null && (filePath = this.normalizeUrlToFile(resourceUrl)) != null) {
                configurationFile = filePath.toString();
            }
            InternalLogger.INSTANCE.info("Configuration file '%s' was %s found by default class loader", this.configurationFileName, configurationFile == null ? "NOT " : "");
            return configurationFile;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                ConfigurationFileLocator.logException(t, "current class loader");
                InternalLogger.INSTANCE.trace("stack trace is : %s", ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    private String getConfigurationFromLibraryLocation() {
        try {
            CodeSource codeSource = ConfigurationFileLocator.class.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                return null;
            }
            String jarFullPath = codeSource.getLocation().toURI().getPath();
            File jarFile = new File(jarFullPath);
            if (jarFile.exists()) {
                String jarDirectory = jarFile.getParent();
                String configurationPath = this.getConfigurationAbsolutePath(jarDirectory);
                if (configurationPath != null) {
                    return configurationPath;
                }
            } else {
                InternalLogger.INSTANCE.warn("Can not access folder '%s'", jarFullPath);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                ConfigurationFileLocator.logException(t, "library location");
                InternalLogger.INSTANCE.trace("stack trace is : %s", ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private String getConfFromClassPath() {
        try {
            URL[] urls;
            ClassLoader classLoader = TelemetryConfigurationFactory.class.getClassLoader();
            if (!(classLoader instanceof URLClassLoader)) {
                return null;
            }
            HashSet<String> checkedUrls = new HashSet<String>();
            for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
                String configurationPath;
                File filePath = this.normalizeUrlToFile(url);
                if (filePath == null) continue;
                if (filePath.isFile()) {
                    filePath = filePath.getParentFile();
                }
                if (checkedUrls.contains(configurationPath = filePath.toString())) continue;
                String configurationFile = this.getConfigurationAbsolutePath(configurationPath);
                if (configurationFile != null) {
                    return configurationFile;
                }
                checkedUrls.add(configurationPath);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                ConfigurationFileLocator.logException(t, "class path");
                InternalLogger.INSTANCE.trace("stack trace is : %s", ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private String getConfigurationAbsolutePath(String path) {
        File configFile = new File(path, this.configurationFileName);
        if (configFile.exists()) {
            return configFile.getAbsolutePath();
        }
        InternalLogger.INSTANCE.info("Did not find configuration file '%s' in '%s'", this.configurationFileName, path);
        return null;
    }

    private File normalizeUrlToFile(URL url) {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            InternalLogger.INSTANCE.warn("Failed to convert URL '%s' to URI, Exception : %s ", url, ExceptionUtils.getStackTrace(e));
            return null;
        }
        return new File(uri.getSchemeSpecificPart());
    }
}

