/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.desktop.os;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.jabref.gui.desktop.os.NativeDesktop;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;

public class OSX
implements NativeDesktop {
    @Override
    public void openFile(String filePath, String fileType) throws IOException {
        Optional<ExternalFileType> type = ExternalFileTypes.getInstance().getExternalFileTypeByExt(fileType);
        if (type.isPresent() && !type.get().getOpenWithApplication().isEmpty()) {
            this.openFileWithApplication(filePath, type.get().getOpenWithApplication());
        } else {
            String[] cmd = new String[]{"/usr/bin/open", filePath};
            Runtime.getRuntime().exec(cmd);
        }
    }

    @Override
    public void openFileWithApplication(String filePath, String application) throws IOException {
        String[] stringArray;
        if (application != null && !application.isEmpty()) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "/usr/bin/open";
            stringArray2[1] = "-a";
            stringArray2[2] = application;
            stringArray = stringArray2;
            stringArray2[3] = filePath;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "/usr/bin/open";
            stringArray = stringArray3;
            stringArray3[1] = filePath;
        }
        String[] cmd = stringArray;
        Runtime.getRuntime().exec(cmd);
    }

    @Override
    public void openFolderAndSelectFile(Path file) throws IOException {
        Desktop.getDesktop().open(file.getParent().toFile());
    }

    @Override
    public void openConsole(String absolutePath) throws IOException {
        Runtime.getRuntime().exec("open -a Terminal " + absolutePath, null, new File(absolutePath));
    }

    @Override
    public void openPdfWithParameters(String filePath, List<String> parameters) throws IOException {
    }

    @Override
    public String detectProgramPath(String programName, String directoryName) {
        return programName;
    }

    @Override
    public Path getApplicationDirectory() {
        return Paths.get("/Applications", new String[0]);
    }
}

