/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.SwingWorker;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.search.SearchResultFrame;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.search.SearchQuery;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GlobalSearchWorker
extends SwingWorker<Map<BasePanel, List<BibEntry>>, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalSearchWorker.class);
    private final JabRefFrame frame;
    private final SearchQuery searchQuery;
    private final SearchResultFrame dialog;

    public GlobalSearchWorker(JabRefFrame frame, SearchQuery query) {
        this.frame = Objects.requireNonNull(frame);
        this.searchQuery = Objects.requireNonNull(query);
        this.dialog = new SearchResultFrame(frame, Localization.lang("Search results in all libraries for %0", this.searchQuery.localize()), this.searchQuery, true);
        frame.getGlobalSearchBar().setSearchResultFrame(this.dialog);
    }

    @Override
    protected Map<BasePanel, List<BibEntry>> doInBackground() throws Exception {
        HashMap<BasePanel, List<BibEntry>> matches = new HashMap<BasePanel, List<BibEntry>>();
        for (BasePanel basePanel : this.frame.getBasePanelList()) {
            matches.put(basePanel, basePanel.getDatabase().getEntries().parallelStream().filter(this.searchQuery::isMatch).collect(Collectors.toList()));
        }
        return matches;
    }

    @Override
    protected void done() {
        if (this.isCancelled()) {
            return;
        }
        try {
            for (Map.Entry match : ((Map)this.get()).entrySet()) {
                this.dialog.addEntries((List)match.getValue(), (BasePanel)match.getKey());
            }
            this.dialog.selectFirstEntry();
            this.dialog.setVisible(true);
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("something went wrong during the search", e);
        }
    }
}

