/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.exporter.BibTeXMLExporter;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.exporter.MSBibExporter;
import org.jabref.logic.exporter.ModsExporter;
import org.jabref.logic.exporter.OpenDocumentSpreadsheetCreator;
import org.jabref.logic.exporter.OpenOfficeDocumentCreator;
import org.jabref.logic.exporter.SavePreferences;
import org.jabref.logic.exporter.TemplateExporter;
import org.jabref.logic.exporter.XmpExporter;
import org.jabref.logic.exporter.XmpPdfExporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.xmp.XmpPreferences;

public class ExporterFactory {
    @Deprecated
    public static int entryNumber;
    private final List<Exporter> exporters;

    private ExporterFactory(List<Exporter> exporters) {
        this.exporters = Objects.requireNonNull(exporters);
    }

    public static ExporterFactory create(Map<String, TemplateExporter> customFormats, LayoutFormatterPreferences layoutPreferences, SavePreferences savePreferences, XmpPreferences xmpPreferences) {
        ArrayList<Exporter> exporters = new ArrayList<Exporter>();
        exporters.add(new TemplateExporter("HTML", "html", "html", null, StandardFileType.HTML, layoutPreferences, savePreferences));
        exporters.add(new TemplateExporter(Localization.lang("Simple HTML", new String[0]), "simplehtml", "simplehtml", null, StandardFileType.HTML, layoutPreferences, savePreferences));
        exporters.add(new TemplateExporter("DocBook 4.4", "docbook", "docbook", null, StandardFileType.XML, layoutPreferences, savePreferences));
        exporters.add(new TemplateExporter("DIN 1505", "din1505", "din1505winword", "din1505", StandardFileType.RTF, layoutPreferences, savePreferences));
        exporters.add(new TemplateExporter("BibO RDF", "bibordf", "bibordf", null, StandardFileType.RDF, layoutPreferences, savePreferences));
        exporters.add(new TemplateExporter(Localization.lang("HTML table", new String[0]), "tablerefs", "tablerefs", "tablerefs", StandardFileType.HTML, layoutPreferences, savePreferences));
        exporters.add(new TemplateExporter(Localization.lang("HTML list", new String[0]), "listrefs", "listrefs", "listrefs", StandardFileType.HTML, layoutPreferences, savePreferences));
        exporters.add(new TemplateExporter(Localization.lang("HTML table (with Abstract & BibTeX)", new String[0]), "tablerefsabsbib", "tablerefsabsbib", "tablerefsabsbib", StandardFileType.HTML, layoutPreferences, savePreferences));
        exporters.add(new TemplateExporter("Harvard RTF", "harvard", "harvard", "harvard", StandardFileType.RDF, layoutPreferences, savePreferences));
        exporters.add(new TemplateExporter("ISO 690 RTF", "iso690rtf", "iso690RTF", "iso690rtf", StandardFileType.RTF, layoutPreferences, savePreferences));
        exporters.add(new TemplateExporter("ISO 690", "iso690txt", "iso690", "iso690txt", StandardFileType.TXT, layoutPreferences, savePreferences));
        exporters.add(new TemplateExporter("Endnote", "endnote", "EndNote", "endnote", StandardFileType.TXT, layoutPreferences, savePreferences));
        exporters.add(new TemplateExporter("OpenOffice/LibreOffice CSV", "oocsv", "openoffice-csv", "openoffice", StandardFileType.CSV, layoutPreferences, savePreferences));
        exporters.add(new TemplateExporter("RIS", "ris", "ris", "ris", StandardFileType.RIS, layoutPreferences, savePreferences).withEncoding(StandardCharsets.UTF_8));
        exporters.add(new TemplateExporter("MIS Quarterly", "misq", "misq", "misq", StandardFileType.RTF, layoutPreferences, savePreferences));
        exporters.add(new BibTeXMLExporter());
        exporters.add(new OpenOfficeDocumentCreator());
        exporters.add(new OpenDocumentSpreadsheetCreator());
        exporters.add(new MSBibExporter());
        exporters.add(new ModsExporter());
        exporters.add(new XmpExporter(xmpPreferences));
        exporters.add(new XmpPdfExporter(xmpPreferences));
        exporters.addAll(customFormats.values());
        return new ExporterFactory(exporters);
    }

    public String getExportersAsString(int maxLineLength, int firstLineSubtraction, String linePrefix) {
        StringBuilder builder = new StringBuilder();
        int lastBreak = -firstLineSubtraction;
        for (Exporter exporter : this.exporters) {
            String name = exporter.getId();
            if (builder.length() + 2 + name.length() - lastBreak > maxLineLength) {
                builder.append(",\n");
                lastBreak = builder.length();
                builder.append(linePrefix);
            } else if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(name);
        }
        return builder.toString();
    }

    public List<Exporter> getExporters() {
        return Collections.unmodifiableList(this.exporters);
    }

    public Optional<Exporter> getExporterByName(String consoleName) {
        return this.exporters.stream().filter(exporter -> exporter.getId().equalsIgnoreCase(consoleName)).findFirst();
    }
}

