/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jabref.logic.exporter.BibDatabaseWriter;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.exporter.ExporterFactory;
import org.jabref.logic.exporter.FileSaveSession;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.exporter.SavePreferences;
import org.jabref.logic.exporter.SaveSession;
import org.jabref.logic.exporter.VerifyingWriter;
import org.jabref.logic.layout.Layout;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.layout.LayoutHelper;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateExporter
extends Exporter {
    private static final String LAYOUT_PREFIX = "/resource/layout/";
    private static final Pattern BLANK_LINE_MATCHER = Pattern.compile("(?m)^\\s");
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateExporter.class);
    private final String lfFileName;
    private final String directory;
    private final LayoutFormatterPreferences layoutPreferences;
    private final SavePreferences savePreferences;
    private Charset encoding;
    private boolean customExport;
    private boolean deleteBlankLines;

    public TemplateExporter(String displayName, String consoleName, String lfFileName, String directory, FileType extension) {
        this(displayName, consoleName, lfFileName, directory, extension, null, null);
    }

    public TemplateExporter(String displayName, String consoleName, String lfFileName, String directory, FileType extension, LayoutFormatterPreferences layoutPreferences, SavePreferences savePreferences) {
        super(consoleName, displayName, extension);
        this.lfFileName = Objects.requireNonNull(lfFileName);
        this.directory = directory;
        this.layoutPreferences = layoutPreferences;
        this.savePreferences = savePreferences;
    }

    public TemplateExporter(String consoleName, String lfFileName, String directory, StandardFileType extension, LayoutFormatterPreferences layoutPreferences, SavePreferences savePreferences, boolean deleteBlankLines) {
        this(consoleName, consoleName, lfFileName, directory, extension, layoutPreferences, savePreferences);
        this.deleteBlankLines = deleteBlankLines;
    }

    public void setCustomExport(boolean custom) {
        this.customExport = custom;
    }

    public TemplateExporter withEncoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    private Reader getReader(String filename) throws IOException {
        InputStreamReader reader;
        String dir = this.customExport ? "" : LAYOUT_PREFIX + (this.directory == null ? "" : this.directory + '/');
        String name = dir + filename;
        URL reso = TemplateExporter.class.getResource(name);
        try {
            if (reso == null) {
                File f = new File(name);
                reader = new FileReader(f);
            } else {
                reader = new InputStreamReader(reso.openStream());
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException("Cannot find layout file: '" + name + "'.");
        }
        return reader;
    }

    @Override
    public void export(BibDatabaseContext databaseContext, Path file, Charset encoding, List<BibEntry> entries) throws Exception {
        Objects.requireNonNull(databaseContext);
        Objects.requireNonNull(entries);
        if (entries.isEmpty()) {
            return;
        }
        SaveSession saveSession = null;
        if (this.encoding != null) {
            try {
                saveSession = new FileSaveSession(this.encoding, false);
            }
            catch (SaveException ex) {
                LOGGER.warn("Cannot get save session.", ex);
            }
        }
        if (saveSession == null) {
            saveSession = new FileSaveSession(encoding, false);
        }
        try (VerifyingWriter ps = saveSession.getWriter();){
            Layout defLayout;
            LayoutHelper layoutHelper;
            Layout beginLayout = null;
            this.readFormatterFile();
            ArrayList<String> missingFormatters = new ArrayList<String>(1);
            try (Reader reader2 = this.getReader(this.lfFileName + ".begin.layout");){
                layoutHelper = new LayoutHelper(reader2, this.layoutPreferences);
                beginLayout = layoutHelper.getLayoutFromText();
            }
            catch (IOException reader2) {
                // empty catch block
            }
            if (beginLayout != null) {
                ps.write(beginLayout.doLayout(databaseContext, encoding));
                missingFormatters.addAll(beginLayout.getMissingFormatters());
            }
            List<BibEntry> sorted = BibDatabaseWriter.getSortedEntries(databaseContext, entries, this.savePreferences);
            try (Reader reader = this.getReader(this.lfFileName + ".layout");){
                layoutHelper = new LayoutHelper(reader, this.layoutPreferences);
                defLayout = layoutHelper.getLayoutFromText();
            }
            if (defLayout != null) {
                missingFormatters.addAll(defLayout.getMissingFormatters());
                if (!missingFormatters.isEmpty()) {
                    LOGGER.warn("Missing formatters found ", (Object)missingFormatters);
                }
            }
            HashMap<String, Layout> layouts = new HashMap<String, Layout>();
            ExporterFactory.entryNumber = 0;
            for (BibEntry entry : sorted) {
                Layout layout;
                ++ExporterFactory.entryNumber;
                String type = entry.getType();
                if (layouts.containsKey(type)) {
                    layout = (Layout)layouts.get(type);
                } else {
                    try (Reader reader = this.getReader(this.lfFileName + '.' + type + ".layout");){
                        layoutHelper = new LayoutHelper(reader, this.layoutPreferences);
                        layout = layoutHelper.getLayoutFromText();
                        layouts.put(type, layout);
                        if (layout != null) {
                            missingFormatters.addAll(layout.getMissingFormatters());
                        }
                    }
                    catch (IOException ex) {
                        layout = defLayout;
                    }
                }
                if (layout == null) continue;
                if (this.deleteBlankLines) {
                    String withoutBlankLines = BLANK_LINE_MATCHER.matcher(layout.doLayout(entry, databaseContext.getDatabase())).replaceAll("");
                    ps.write(withoutBlankLines);
                    continue;
                }
                ps.write(layout.doLayout(entry, databaseContext.getDatabase()));
            }
            Layout endLayout = null;
            try (Reader reader3 = this.getReader(this.lfFileName + ".end.layout");){
                layoutHelper = new LayoutHelper(reader3, this.layoutPreferences);
                endLayout = layoutHelper.getLayoutFromText();
            }
            catch (IOException reader3) {
                // empty catch block
            }
            if (endLayout != null) {
                ps.write(endLayout.doLayout(databaseContext, this.encoding));
                missingFormatters.addAll(endLayout.getMissingFormatters());
            }
            this.layoutPreferences.clearCustomExportNameFormatters();
            if (!missingFormatters.isEmpty()) {
                StringBuilder sb = new StringBuilder("The following formatters could not be found: ");
                sb.append(String.join((CharSequence)", ", missingFormatters));
                LOGGER.warn("Formatters not found", (Object)sb);
            }
            saveSession.finalize(file);
        }
    }

    private void readFormatterFile() {
        File formatterFile = new File(this.lfFileName + ".formatters");
        if (formatterFile.exists()) {
            try (FileReader in = new FileReader(formatterFile);){
                String[] lines;
                int c;
                StringBuilder sb = new StringBuilder();
                while ((c = ((Reader)in).read()) != -1) {
                    sb.append((char)c);
                }
                for (String line1 : lines = sb.toString().split("\n")) {
                    int index;
                    String line = line1.trim();
                    if (line.isEmpty() || (index = line.indexOf(58)) <= 0 || index + 1 >= line.length()) continue;
                    String formatterName = line.substring(0, index);
                    String contents = line.substring(index + 1);
                    this.layoutPreferences.putCustomExportNameFormatter(formatterName, contents);
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Problem opening formatter file.", ex);
            }
        }
    }
}

