/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.xmp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.jabref.logic.xmp.DocumentInformationExtractor;
import org.jabref.logic.xmp.DublinCoreExtractor;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.logic.xmp.XmpUtilShared;
import org.jabref.model.entry.BibEntry;

public class XmpUtilReader {
    private static final String START_TAG = "<rdf:Description";
    private static final String END_TAG = "</rdf:Description>";

    private XmpUtilReader() {
    }

    public static List<XMPMetadata> readRawXmp(Path path) throws IOException {
        try (PDDocument document = XmpUtilReader.loadWithAutomaticDecryption(path);){
            List<XMPMetadata> list = XmpUtilReader.getXmpMetadata(document);
            return list;
        }
    }

    public static List<BibEntry> readXmp(String filename, XmpPreferences xmpPreferences) throws IOException {
        return XmpUtilReader.readXmp(Paths.get(filename, new String[0]), xmpPreferences);
    }

    public static List<BibEntry> readXmp(Path path, XmpPreferences xmpPreferences) throws IOException {
        LinkedList<BibEntry> result = new LinkedList<BibEntry>();
        try (PDDocument document = XmpUtilReader.loadWithAutomaticDecryption(path);){
            List<XMPMetadata> xmpMetaList = XmpUtilReader.getXmpMetadata(document);
            if (!xmpMetaList.isEmpty()) {
                for (XMPMetadata xmpMeta : xmpMetaList) {
                    DublinCoreExtractor dcExtractor;
                    Optional<BibEntry> entry;
                    DublinCoreSchema dcSchema = xmpMeta.getDublinCoreSchema();
                    if (dcSchema == null || !(entry = (dcExtractor = new DublinCoreExtractor(dcSchema, xmpPreferences, new BibEntry())).extractBibtexEntry()).isPresent()) continue;
                    result.add(entry.get());
                }
            }
            if (result.isEmpty()) {
                PDDocumentInformation documentInformation = document.getDocumentInformation();
                DocumentInformationExtractor diExtractor = new DocumentInformationExtractor(documentInformation);
                Optional<BibEntry> entry = diExtractor.extractBibtexEntry();
                entry.ifPresent(result::add);
            }
        }
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        return result;
    }

    private static List<XMPMetadata> getXmpMetadata(PDDocument document) throws IOException {
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        PDMetadata metaRaw = catalog.getMetadata();
        ArrayList<XMPMetadata> metaList = new ArrayList<XMPMetadata>();
        if (metaRaw == null) {
            return metaList;
        }
        String xmp = metaRaw.getCOSObject().toTextString();
        int startDescriptionSection = xmp.indexOf(START_TAG);
        int endDescriptionSection = xmp.lastIndexOf(END_TAG) + END_TAG.length();
        String start = xmp.substring(0, startDescriptionSection);
        String[] descriptionsArray = xmp.substring(startDescriptionSection, endDescriptionSection).split(END_TAG);
        String end = xmp.substring(endDescriptionSection);
        for (String s2 : descriptionsArray) {
            String xmpMetaString = start + s2 + END_TAG + end;
            metaList.add(XmpUtilShared.parseXmpMetadata(new ByteArrayInputStream(xmpMetaString.getBytes())));
        }
        return metaList;
    }

    public static PDDocument loadWithAutomaticDecryption(Path path) throws IOException {
        PDDocument doc = PDDocument.load(path.toFile());
        return doc;
    }
}

