/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.identifier;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.model.entry.identifier.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Eprint
implements Identifier {
    public static final URI RESOLVER = URI.create("https://arxiv.org");
    private static final Logger LOGGER = LoggerFactory.getLogger(Eprint.class);
    private static final String EPRINT_EXP = "(?:arXiv:)?(\\d{4}\\.\\d{4,5}(v\\d+)?|.+(\\.\\w{2})?\\/\\d{7})";
    private static final String HTTP_EXP = "https?://[^\\s]+?(?:arXiv:)?(\\d{4}\\.\\d{4,5}(v\\d+)?|.+(\\.\\w{2})?\\/\\d{7})";
    private static final Pattern EXACT_EPRINT_PATT = Pattern.compile("^(?:https?://[^\\s]+?)?(?:arXiv:)?(\\d{4}\\.\\d{4,5}(v\\d+)?|.+(\\.\\w{2})?\\/\\d{7})$", 2);
    private final String eprint;

    public Eprint(String eprint) {
        Matcher matcher;
        Objects.requireNonNull(eprint);
        String trimmedId = eprint.trim();
        if (eprint.matches(HTTP_EXP)) {
            try {
                URI url = new URI(trimmedId);
                trimmedId = url.getScheme() + "://" + url.getHost() + url.getPath();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(eprint + " is not a valid HTTP Eprint identifier.");
            }
        }
        if (!(matcher = EXACT_EPRINT_PATT.matcher(trimmedId)).find()) {
            throw new IllegalArgumentException(trimmedId + " is not a valid Eprint identifier.");
        }
        this.eprint = matcher.group(1);
    }

    public static Optional<Eprint> build(String eprint) {
        try {
            return Optional.ofNullable(new Eprint(eprint));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<URI> getExternalURI() {
        try {
            URI uri = new URI(RESOLVER.getScheme(), RESOLVER.getHost(), "/abs/" + this.eprint, null);
            return Optional.of(uri);
        }
        catch (URISyntaxException e) {
            LOGGER.error(this.eprint + " could not be encoded as URI.", e);
            return Optional.empty();
        }
    }

    public String getURIAsASCIIString() {
        return this.getExternalURI().map(URI::toASCIIString).orElse("");
    }

    public String getEprint() {
        return this.eprint;
    }

    @Override
    public String getDefaultField() {
        return "eprint";
    }

    @Override
    public String getNormalized() {
        return this.eprint;
    }
}

