/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.Command;
import tim.prune.cmd.CompoundCommand;
import tim.prune.cmd.ConnectMediaCmd;
import tim.prune.cmd.DeletePointCmd;
import tim.prune.cmd.RemoveAudioCmd;
import tim.prune.cmd.RemovePhotoCmd;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.Photo;
import tim.prune.function.Describer;
import tim.prune.function.media.PopupResponse;

public class DeleteCurrentPoint
extends GenericFunction {
    public DeleteCurrentPoint(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "menu.point.deletepoint";
    }

    @Override
    public void begin() {
        Object object;
        Object object2;
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        if (dataPoint == null) {
            return;
        }
        PopupResponse popupResponse = this.shouldDeleteMedia(dataPoint);
        if (popupResponse == PopupResponse.CANCEL) {
            return;
        }
        if (popupResponse == PopupResponse.MEDIA_NOT_CONNECTED) {
            object2 = new DeletePointCmd(this._app.getTrackInfo().getSelection().getCurrentPointIndex(), dataPoint.getWaypointName());
        } else {
            object = new CompoundCommand(127);
            ((CompoundCommand)object).addCommand(new DeletePointCmd(this._app.getTrackInfo().getSelection().getCurrentPointIndex(), dataPoint.getWaypointName()));
            Photo photo = dataPoint.getPhoto();
            AudioClip audioClip = dataPoint.getAudio();
            if (popupResponse == PopupResponse.DELETE) {
                if (photo != null) {
                    ((CompoundCommand)object).addCommand(new RemovePhotoCmd(this._app.getTrackInfo().getPhotoList().getIndexOf(photo)));
                }
                if (audioClip != null) {
                    ((CompoundCommand)object).addCommand(new RemoveAudioCmd(this._app.getTrackInfo().getAudioList().getIndexOf(audioClip)));
                }
            } else {
                ((CompoundCommand)object).addCommand(new ConnectMediaCmd(dataPoint, null, null));
            }
            object2 = object;
        }
        object = new Describer("undo.deletepoint", "undo.deletepoint.withname");
        ((Command)object2).setDescription(((Describer)object).getDescriptionWithNameOrNot(dataPoint.getWaypointName()));
        ((Command)object2).setConfirmText(I18nManager.getText("confirm.deletepoint.single"));
        this._app.execute((Command)object2);
    }

    private PopupResponse shouldDeleteMedia(DataPoint dataPoint) {
        boolean bl;
        boolean bl2 = dataPoint.getPhoto() != null;
        boolean bl3 = bl = dataPoint.getAudio() != null;
        if (!bl2 && !bl) {
            return PopupResponse.MEDIA_NOT_CONNECTED;
        }
        String string = bl2 && bl ? I18nManager.getText("dialog.deletepoint.deletephotoandaudio") : (bl2 ? I18nManager.getText("dialog.deletepoint.deletephoto", dataPoint.getPhoto().getName()) : I18nManager.getText("dialog.deletepoint.deleteaudio", dataPoint.getAudio().getName()));
        int n = JOptionPane.showConfirmDialog(this._app.getFrame(), string, I18nManager.getText("dialog.deletepoint.title"), 1);
        if (n == 2 || n == -1) {
            return PopupResponse.CANCEL;
        }
        return n == 0 ? PopupResponse.DELETE : PopupResponse.UNLINK;
    }
}

