/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

final class NonStretchingViewTabLayoutModel
implements TabLayoutModel {
    private TabDataModel model;
    private TabDisplayer tabDisplayer;
    private static final int PADDING_RIGHT = 35;
    private static final int ICON_X_PAD = 4;
    private Dimension padding = new Dimension(10, 0);

    public NonStretchingViewTabLayoutModel(TabDataModel tabDataModel, TabDisplayer tabDisplayer) {
        this.model = tabDataModel;
        this.tabDisplayer = tabDisplayer;
    }

    @Override
    public int getH(int n) {
        this.checkIndex(n);
        Insets insets = this.tabDisplayer.getInsets();
        return this.tabDisplayer.getHeight() - (insets.bottom + insets.top);
    }

    @Override
    public int getW(int n) {
        this.checkIndex(n);
        return this.getXCoords()[n] - this.getX(n);
    }

    @Override
    public int getX(int n) {
        this.checkIndex(n);
        return n > 0 ? this.getXCoords()[n - 1] : this.tabDisplayer.getInsets().left;
    }

    @Override
    public int getY(int n) {
        this.checkIndex(n);
        return this.tabDisplayer.getInsets().top;
    }

    @Override
    public int indexOfPoint(int n, int n2) {
        Insets insets = this.tabDisplayer.getInsets();
        int n3 = this.tabDisplayer.getWidth() - (insets.left + insets.right + 35);
        int n4 = this.tabDisplayer.getHeight() - (insets.bottom + insets.top);
        if (n2 < insets.top || n2 > n4 || n < insets.left || n > n3) {
            return -1;
        }
        int n5 = this.model.size();
        for (int i = 0; i < n5; ++i) {
            int n6 = n - this.getX(i);
            if (n6 < 0 || n6 >= this.getW(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int dropIndexOfPoint(int n, int n2) {
        Insets insets = this.tabDisplayer.getInsets();
        int n3 = this.tabDisplayer.getWidth() - (insets.left + insets.right + 35);
        int n4 = this.tabDisplayer.getHeight() - (insets.bottom + insets.top);
        if (n2 < insets.top || n2 > n4 || n < insets.left || n > n3) {
            return -1;
        }
        int n5 = this.model.size();
        int[] nArray = this.getXCoords();
        for (int i = 0; i < nArray.length; ++i) {
            if (n >= nArray[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setPadding(Dimension dimension) {
        this.padding = new Dimension(dimension);
    }

    private void checkIndex(int n) {
        int n2 = this.model.size();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Index out of valid scope 0.." + (n2 - 1) + ": " + n);
        }
    }

    private int[] getXCoords() {
        int n;
        int n2;
        int n3 = this.model.size();
        int[] nArray = new int[n3];
        Insets insets = this.tabDisplayer.getInsets();
        double d = insets.left;
        int n4 = this.tabDisplayer.getWidth() - insets.right - 35;
        if (n4 - insets.left / n3 < 5) {
            NonStretchingViewTabLayoutModel.makeEqualSized(nArray, insets.left, n4);
            return nArray;
        }
        Icon icon = this.tabDisplayer.getUI().getButtonIcon(1, 0);
        int n5 = 0;
        if (null != icon) {
            n5 += icon.getIconWidth();
            n5 += 4;
        }
        int n6 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            int n7 = n2;
            String string = this.model.getTab(n7).getText();
            d += HtmlRenderer.renderString((String)string, (Graphics)BasicScrollingTabDisplayerUI.getOffscreenGraphics(this.tabDisplayer), (int)0, (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (Font)this.tabDisplayer.getFont(), (Color)Color.BLACK, (int)1, (boolean)false);
            d += (double)this.padding.width;
            nArray[n2] = (int)Math.round(d += (double)n5);
            n = n2 == 0 ? nArray[n2] : nArray[n2] - nArray[n2 - 1];
            n6 = Math.max(n6, n);
        }
        if (nArray[nArray.length - 1] > n4) {
            n2 = NonStretchingViewTabLayoutModel.findSecondMaxWidth(nArray, n6);
            n = nArray[nArray.length - 1] - n4;
            NonStretchingViewTabLayoutModel.makeShorter(nArray, n2, n6, n);
            if (nArray[nArray.length - 1] > n4) {
                n6 = n2;
                n2 = NonStretchingViewTabLayoutModel.findSecondMaxWidth(nArray, n2);
                n = nArray[nArray.length - 1] - n4;
                NonStretchingViewTabLayoutModel.makeShorter(nArray, n2, n6, n);
                if (nArray[nArray.length - 1] > n4) {
                    NonStretchingViewTabLayoutModel.makeEqualSized(nArray, insets.left, n4);
                }
            }
        }
        return nArray;
    }

    private static void makeEqualSized(int[] nArray, int n, int n2) {
        int n3 = Math.max((n2 - n) / nArray.length, 1);
        nArray[0] = n + n3;
        for (int i = 1; i < nArray.length; ++i) {
            nArray[i] = nArray[i - 1] + n3;
        }
    }

    private static void makeShorter(int[] nArray, int n, int n2, int n3) {
        int n4 = NonStretchingViewTabLayoutModel.countTabsWiderThan(nArray, n);
        if (0 == n4) {
            return;
        }
        int n5 = 0;
        int n6 = Math.max(n3 / n4, 1);
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n7 = nArray[i];
            if (i > 0) {
                n7 -= nArray[i - 1];
            }
            if (n7 < n) continue;
            int n8 = Math.min(n7 - n, n6);
            int n9 = i;
            while (n9 < nArray.length) {
                int n10 = n9++;
                nArray[n10] = nArray[n10] - n8;
            }
            if ((n5 += n8) >= n3) break;
        }
    }

    private static void makeShorterEqually(int[] nArray, int n) {
        int n2 = Math.max(n / nArray.length, 1);
        int n3 = 0;
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n4 = nArray[i];
            if (i > 0) {
                n4 -= nArray[i - 1];
            }
            if (n4 < 5) continue;
            int n5 = Math.min(n4 - 5, n2);
            int n6 = i;
            while (n6 < nArray.length) {
                int n7 = n6++;
                nArray[n7] = nArray[n7] - n5;
            }
            if ((n3 += n5) >= n) break;
        }
    }

    private static int findSecondMaxWidth(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3;
            int n4 = n3 = i == 0 ? nArray[i] : nArray[i] - nArray[i - 1];
            if (n3 <= n2 || n3 >= n) continue;
            n2 = n3;
        }
        return n2;
    }

    private static int countTabsWiderThan(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3;
            int n4 = n3 = i == 0 ? nArray[i] : nArray[i] - nArray[i - 1];
            if (n3 <= n) continue;
            ++n2;
        }
        return n2;
    }
}

