/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.scanner;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.insane.scanner.ObjectMap;
import org.netbeans.insane.scanner.ScannerUtils;
import org.netbeans.insane.scanner.Visitor;

public class CountingVisitor
implements Visitor {
    private Map<Class<?>, Info> infoMap = new HashMap();
    private int count;
    private int size;

    @Override
    public void visitClass(Class<?> clazz) {
        this.infoMap.put(clazz, new Info());
    }

    @Override
    public void visitObject(ObjectMap objectMap, Object object) {
        Info info = this.infoMap.get(object.getClass());
        assert (info != null) : "Engine shall announce the class before instance";
        ++info.count;
        ++this.count;
        int n = ScannerUtils.sizeOf(object);
        info.size += n;
        this.size += n;
    }

    @Override
    public void visitStaticReference(ObjectMap objectMap, Object object, Field field) {
    }

    @Override
    public void visitObjectReference(ObjectMap objectMap, Object object, Object object2, Field field) {
    }

    @Override
    public void visitArrayReference(ObjectMap objectMap, Object object, Object object2, int n) {
    }

    public Set<Class<?>> getClasses() {
        return Collections.unmodifiableSet(this.infoMap.keySet());
    }

    public int getCountForClass(Class clazz) {
        Info info = this.infoMap.get(clazz);
        if (info == null) {
            throw new IllegalArgumentException("Unknown class");
        }
        return info.count;
    }

    public int getSizeForClass(Class clazz) {
        Info info = this.infoMap.get(clazz);
        if (info == null) {
            throw new IllegalArgumentException("Unknown class");
        }
        return info.size;
    }

    public int getTotalCount() {
        return this.count;
    }

    public int getTotalSize() {
        return this.size;
    }

    private static class Info {
        int count;
        int size;

        private Info() {
        }
    }
}

