/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit.swingui.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.antlr.gunit.swingui.model.Rule;
import org.antlr.runtime.CommonTokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuite {
    private List<Rule> rules = new ArrayList<Rule>();
    private String grammarName = "";
    private String grammarDir = "";
    private CommonTokenStream tokens;
    private static final String TEST_SUITE_EXT = ".gunit";
    private static final String GRAMMAR_EXT = ".g";

    public TestSuite() {
    }

    public TestSuite(File grammarFile, List<Rule> rules) {
        String grammarFileName = grammarFile.getName();
        this.grammarName = grammarFileName.substring(0, grammarFileName.lastIndexOf("."));
        this.grammarDir = grammarFile.getParent();
    }

    public String getTestSuiteFileName() {
        return this.grammarDir + File.separator + this.grammarName + TEST_SUITE_EXT;
    }

    public String getGrammarFileName() {
        return this.grammarDir + File.separator + this.grammarName + GRAMMAR_EXT;
    }

    public void addRule(Rule currentRule) {
        if (currentRule == null) {
            throw new IllegalArgumentException("Null rule");
        }
        this.rules.add(currentRule);
    }

    public boolean hasRule(Rule rule) {
        for (Rule r : this.rules) {
            if (!r.getName().equals(rule.getName())) continue;
            return true;
        }
        return false;
    }

    public int getRuleCount() {
        return this.rules.size();
    }

    public void setRules(List<Rule> newRules) {
        this.rules.clear();
        this.rules.addAll(newRules);
    }

    public void setGrammarName(String name) {
        this.grammarName = name;
    }

    public String getGrammarName() {
        return this.grammarName;
    }

    public Rule getRule(int index) {
        return this.rules.get(index);
    }

    public CommonTokenStream getTokens() {
        return this.tokens;
    }

    public void setTokens(CommonTokenStream ts) {
        this.tokens = ts;
    }

    public Rule getRule(String name) {
        for (Rule rule : this.rules) {
            if (!rule.getName().equals(name)) continue;
            return rule;
        }
        return null;
    }

    public List getRulesForStringTemplate() {
        return this.rules;
    }
}

