/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.structures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.ui.internal.spreadsheet.structures.RowHead;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowOrder {
    public static final RowOrder EMPTY = new RowOrder(true);
    private List<RowHead> heads;

    public RowOrder() {
        this(false);
    }

    private RowOrder(boolean empty) {
        this.heads = empty ? Collections.emptyList() : new ArrayList<RowHead>();
    }

    public void addRowHead(RowHead head) {
        if (this != EMPTY) {
            this.heads.add(head);
        }
    }

    public boolean isEmpty() {
        return this.heads.isEmpty();
    }

    public List<RowHead> getHeads() {
        return this.heads;
    }

    public int compareRows(RowHead head1, RowHead head2) {
        int index1 = this.heads.indexOf(head1);
        int index2 = this.heads.indexOf(head2);
        if (index1 < 0) {
            if (index2 < 0) {
                return head1.compareTo(head2);
            }
            return 1;
        }
        if (index2 < 0) {
            return -1;
        }
        return index1 - index2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RowOrder)) {
            return false;
        }
        RowOrder that = (RowOrder)obj;
        if (this.heads.size() != that.heads.size()) {
            return false;
        }
        int i = 0;
        while (i < this.heads.size()) {
            RowHead h2;
            RowHead h1 = this.heads.get(i);
            if (!h1.equals(h2 = that.heads.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.heads.hashCode();
    }

    public static RowOrder createFromTopic(ITopic topic) {
        List rows;
        ITopicExtensionElement content;
        List children;
        ITopicExtension ext = topic.getExtension("org.xmind.ui.spreadsheet");
        if (ext != null && !(children = (content = ext.getContent()).getChildren("rows")).isEmpty() && !(rows = ((ITopicExtensionElement)children.get(0)).getChildren("row")).isEmpty()) {
            RowOrder order = new RowOrder();
            for (ITopicExtensionElement row : rows) {
                String text = row.getTextContent();
                if (text == null) continue;
                order.addRowHead(new RowHead(text));
            }
            return order;
        }
        return EMPTY;
    }
}

