/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.osgi.service.event.Event;

public class CommandLabelUpdater
implements IPropertyChangeListener {
    private static final int TEXT = 2;
    private static final int TOOLTIP = 4;
    private static final String DATA_ORIGINAL_TEXT = "CommandLabelUpdater:OriginalText";
    private static final String DATA_ORIGINAL_TOOLTIP = "CommandLabelUpdater:OriginalTooltip";
    private static final String WEAK_VALUE_PLACEHOLDER = "WeakValuePlaceHolder";
    @Inject
    private EModelService modelService;
    private MWindow activeWindow = null;
    private WeakHashMap<IActionBars, String> activeActionBarsWeakRef = new WeakHashMap();
    private Set<IAction> trackedHandlers = null;

    @Inject
    @Optional
    public void applicationStarted(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event) {
    }

    @Inject
    @Optional
    public void activePartChanged(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event) {
        Object element = event.getProperty("ChangedElement");
        if (!(element instanceof MPart)) {
            return;
        }
        MPart part = (MPart)element;
        MWindow window = this.findWindowFor((MUIElement)part);
        if (window == null) {
            return;
        }
        this.partActivated(part, window);
    }

    private void partActivated(MPart part, MWindow window) {
        IActionBars activeActionBars;
        IWorkbenchWindow ww = (IWorkbenchWindow)window.getContext().get(IWorkbenchWindow.class);
        IActionBars actionBars = this.findActionBars(ww);
        this.activeWindow = window;
        Object[] bars = this.activeActionBarsWeakRef.keySet().toArray();
        IActionBars iActionBars = activeActionBars = bars.length > 0 ? (IActionBars)bars[0] : null;
        if (actionBars != activeActionBars) {
            if (activeActionBars instanceof SubActionBars) {
                ((SubActionBars)activeActionBars).removePropertyChangeListener((IPropertyChangeListener)this);
            }
            this.activeActionBarsWeakRef.put(actionBars, WEAK_VALUE_PLACEHOLDER);
            if (actionBars instanceof SubActionBars) {
                ((SubActionBars)actionBars).addPropertyChangeListener((IPropertyChangeListener)this);
            }
            this.updateAllItemLabels();
        }
    }

    private void updateAllItemLabels() {
        if (this.activeWindow == null) {
            return;
        }
        Set<IAction> oldTrackedHandlers = this.trackedHandlers;
        HashSet<IAction> newTrackedHandlers = new HashSet<IAction>();
        Object[] bars = this.activeActionBarsWeakRef.keySet().toArray();
        IActionBars activeActionBars = bars.length > 0 ? (IActionBars)bars[0] : null;
        this.updateItemLabel(activeActionBars, (MUIElement)this.activeWindow.getMainMenu(), "undo", ActionFactory.UNDO.getId(), ActionFactory.UNDO.getCommandId(), 2, newTrackedHandlers);
        this.updateItemLabel(activeActionBars, (MUIElement)this.activeWindow.getMainMenu(), "redo", ActionFactory.REDO.getId(), ActionFactory.REDO.getCommandId(), 2, newTrackedHandlers);
        this.updateItemLabel(activeActionBars, (MUIElement)this.activeWindow, "org.xmind.ui.toolbar.edit.undo", ActionFactory.UNDO.getId(), ActionFactory.UNDO.getCommandId(), 4, newTrackedHandlers);
        this.updateItemLabel(activeActionBars, (MUIElement)this.activeWindow, "org.xmind.ui.toolbar.edit.redo", ActionFactory.REDO.getId(), ActionFactory.REDO.getCommandId(), 4, newTrackedHandlers);
        this.trackedHandlers = newTrackedHandlers;
        if (oldTrackedHandlers != null) {
            for (IAction handler : oldTrackedHandlers) {
                if (newTrackedHandlers.contains(handler)) continue;
                handler.removePropertyChangeListener((IPropertyChangeListener)this);
            }
        }
        for (IAction handler : newTrackedHandlers) {
            if (oldTrackedHandlers != null && oldTrackedHandlers.contains(handler)) continue;
            handler.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    private void updateItemLabel(IActionBars actionBars, MUIElement topElement, String itemId, String actionId, String commandId, int attributes, Set<IAction> handlers) {
        IAction handler;
        if (this.modelService == null || topElement == null) {
            return;
        }
        MUIElement element = this.modelService.find(itemId, topElement);
        if (!(element instanceof MItem)) {
            return;
        }
        MItem item = (MItem)element;
        IAction iAction = handler = actionBars == null ? null : actionBars.getGlobalActionHandler(actionId);
        if ((attributes & 2) != 0) {
            String text;
            String string = text = handler == null ? null : handler.getText();
            if (text != null) {
                if (!item.getTransientData().containsKey(DATA_ORIGINAL_TEXT)) {
                    item.getTransientData().put(DATA_ORIGINAL_TEXT, item.getLabel());
                }
                item.setLabel(text);
            } else {
                Object originalText = item.getTransientData().get(DATA_ORIGINAL_TEXT);
                if (originalText != null && originalText instanceof String) {
                    item.setLabel((String)originalText);
                }
            }
        }
        if ((attributes & 4) != 0) {
            String tooltip;
            String string = tooltip = handler == null ? null : handler.getToolTipText();
            if (tooltip != null) {
                if (!item.getTransientData().containsKey(DATA_ORIGINAL_TOOLTIP)) {
                    item.getTransientData().put(DATA_ORIGINAL_TOOLTIP, item.getTooltip());
                }
                item.setTooltip(tooltip);
            } else {
                Object originalTooltip = item.getTransientData().get(DATA_ORIGINAL_TOOLTIP);
                if (originalTooltip != null && originalTooltip instanceof String) {
                    item.setTooltip((String)originalTooltip);
                }
            }
        }
    }

    private MWindow findWindowFor(MUIElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof MWindow) {
            return (MWindow)element;
        }
        MPlaceholder placeholder = element.getCurSharedRef();
        if (placeholder != null) {
            return this.findWindowFor((MUIElement)placeholder);
        }
        MElementContainer parent = element.getParent();
        if (parent != null) {
            return this.findWindowFor((MUIElement)parent);
        }
        return null;
    }

    private IActionBars findActionBars(IWorkbenchWindow window) {
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart == null) {
            return null;
        }
        IWorkbenchPartSite site = activePart.getSite();
        if (site instanceof IEditorSite) {
            return ((IEditorSite)site).getActionBars();
        }
        if (site instanceof IViewSite) {
            return ((IViewSite)site).getActionBars();
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateAllItemLabels();
    }
}

