/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import java.util.Iterator;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.AdvancedToolbarLayout;
import org.xmind.gef.ui.internal.SpaceCollaborativeEngine;

public class ContentPane
extends Figure {
    private AdvancedToolbarLayout layout = null;
    private FlowLayout wrapLayout = null;
    private int minorAlign = -1;
    private int minorSpacing = -1;
    private SpaceCollaborativeEngine spaceCollaborativeEngine = null;

    public ContentPane() {
        this(false, false, false);
    }

    public ContentPane(boolean isHorizontal, boolean stretchMinorAxis, boolean wrap) {
        if (wrap) {
            this.wrapLayout = new ContentPaneFlowLayout(isHorizontal);
            this.wrapLayout.setStretchMinorAxis(stretchMinorAxis);
            this.wrapLayout.setMajorAlignment(0);
            this.wrapLayout.setMinorAlignment(0);
            this.wrapLayout.setMajorSpacing(10);
            this.wrapLayout.setMinorSpacing(5);
            super.setLayoutManager((LayoutManager)this.wrapLayout);
        } else {
            this.layout = new AdvancedToolbarLayout(isHorizontal);
            this.layout.setStretchMinorAxis(stretchMinorAxis);
            this.layout.setMinorAlignment(0);
            this.layout.setMajorAlignment(0);
            this.layout.setInnerMinorAlignment(0);
            this.layout.setSpacing(10);
            super.setLayoutManager((LayoutManager)this.layout);
        }
    }

    public void setLayoutManager(LayoutManager manager) {
    }

    public boolean isHorizontal() {
        if (this.isWrap()) {
            return this.wrapLayout.isHorizontal();
        }
        return this.layout.isHorizontal();
    }

    public void setHorizontal(boolean horizontal) {
        if (horizontal == this.isHorizontal()) {
            return;
        }
        if (this.wrapLayout != null) {
            this.wrapLayout.setHorizontal(horizontal);
        }
        if (this.layout != null) {
            this.layout.setHorizontal(horizontal);
        }
        this.revalidate();
    }

    public boolean isWrap() {
        return this.getLayoutManager() == this.wrapLayout;
    }

    public void setWrap(boolean wrap) {
        if (wrap == this.isWrap()) {
            return;
        }
        if (wrap) {
            if (this.wrapLayout == null) {
                boolean horizontal = this.isHorizontal();
                int majorAlignment = this.getMajorAlignment();
                int minorAlignment = this.getMinorAlignment();
                int majorSpacing = this.getMajorSpacing();
                int minorSpacing = this.getMinorSpacing();
                this.wrapLayout = new ContentPaneFlowLayout(horizontal);
                this.wrapLayout.setMajorAlignment(majorAlignment);
                this.wrapLayout.setMajorSpacing(majorSpacing);
                this.wrapLayout.setMinorSpacing(minorSpacing);
                boolean fill = minorAlignment == 3;
                this.wrapLayout.setStretchMinorAxis(fill);
                this.wrapLayout.setMinorAlignment(fill ? 0 : minorAlignment);
            }
            super.setLayoutManager((LayoutManager)this.wrapLayout);
        } else {
            if (this.layout == null) {
                boolean horizontal = this.isHorizontal();
                int majorAlignment = this.getMajorAlignment();
                int minorAlignment = this.getMinorAlignment();
                this.layout = new AdvancedToolbarLayout(horizontal);
                this.layout.setMajorAlignment(majorAlignment);
                this.layout.setSpacing(this.minorSpacing);
                boolean fill = minorAlignment == 3;
                this.layout.setStretchMinorAxis(fill);
                this.layout.setMinorAlignment(fill ? 0 : minorAlignment);
            }
            super.setLayoutManager((LayoutManager)this.layout);
        }
    }

    public int getMajorAlignment() {
        if (this.isWrap()) {
            return this.wrapLayout.getMajorAlignment();
        }
        return this.layout.getMajorAlignment();
    }

    public int getMinorAlignment() {
        return this.minorAlign;
    }

    public void setMajorAlignment(int alignment) {
        if (alignment == this.getMajorAlignment()) {
            return;
        }
        if (this.wrapLayout != null) {
            this.wrapLayout.setMajorAlignment(alignment);
        }
        if (this.layout != null) {
            this.layout.setMajorAlignment(alignment);
        }
        this.revalidate();
    }

    public void setMinorAlignment(int alignment) {
        boolean fill;
        if (this.minorAlign >= 0 && alignment == this.getMinorAlignment()) {
            return;
        }
        this.minorAlign = alignment;
        boolean bl = fill = alignment == 3;
        if (this.wrapLayout != null) {
            this.wrapLayout.setStretchMinorAxis(fill);
            this.wrapLayout.setMinorAlignment(fill ? 0 : alignment);
        }
        if (this.layout != null) {
            this.layout.setStretchMinorAxis(fill);
            this.layout.setInnerMinorAlignment(fill ? 0 : alignment);
        }
        this.revalidate();
    }

    public int getMajorSpacing() {
        if (this.isWrap()) {
            return this.wrapLayout.getMajorSpacing();
        }
        return this.layout.getSpacing();
    }

    public void setMajorSpacing(int spacing) {
        if (spacing == this.getMajorSpacing()) {
            return;
        }
        if (this.wrapLayout != null) {
            this.wrapLayout.setMajorSpacing(spacing);
        }
        if (this.layout != null) {
            this.layout.setSpacing(spacing);
        }
        this.revalidate();
    }

    public int getMinorSpacing() {
        return this.minorSpacing;
    }

    public void setMinorSpacing(int spacing) {
        if (this.minorSpacing >= 0 && spacing == this.getMinorSpacing()) {
            return;
        }
        this.minorSpacing = spacing;
        if (this.wrapLayout != null) {
            ((ContentPaneFlowLayout)this.wrapLayout).setMinorSpacing2(spacing);
        }
        this.revalidate();
    }

    public void invalidate() {
        if (this.getSpaceCollaborativeEngine() != null) {
            this.getSpaceCollaborativeEngine().refreshMinorSpace();
        }
        super.invalidate();
    }

    public SpaceCollaborativeEngine getSpaceCollaborativeEngine() {
        return this.spaceCollaborativeEngine;
    }

    public void setSpaceCollaborativeEngine(SpaceCollaborativeEngine spaceCollaborativeEngine) {
        this.spaceCollaborativeEngine = spaceCollaborativeEngine;
    }

    private class ContentPaneFlowLayout
    extends FlowLayout {
        private WorkingData2 data2;
        private int minorSpacing2;

        public ContentPaneFlowLayout(boolean isHorizontal) {
            super(isHorizontal);
            this.data2 = null;
            this.minorSpacing2 = 0;
        }

        public void setMinorSpacing2(int minorSpacing2) {
            this.minorSpacing2 = minorSpacing2;
        }

        public int getMinorSpacing2() {
            return this.minorSpacing2;
        }

        public void layout(IFigure parent) {
            this.data2 = new WorkingData2();
            Rectangle relativeArea = parent.getClientArea();
            this.data2.area = this.transposer.t(relativeArea);
            Iterator iterator = parent.getChildren().iterator();
            int wHint = -1;
            int hHint = -1;
            if (this.isHorizontal()) {
                wHint = parent.getClientArea().width;
            } else {
                hHint = parent.getClientArea().height;
            }
            this.initVariables2(parent);
            this.initRow2();
            while (iterator.hasNext()) {
                IFigure f = (IFigure)iterator.next();
                Dimension pref = this.transposer.t(this.getChildSize(f, wHint, hHint));
                Rectangle r = new Rectangle(0, 0, pref.width, pref.height);
                if (this.data2.rowCount > 0 && this.data2.rowWidth + pref.width > this.data2.maxWidth) {
                    this.layoutRow(parent);
                }
                r.x = this.data2.rowX;
                r.y = this.data2.rowY;
                int dx = r.width + Math.max(this.getMinorSpacing(), this.getMinorSpacing2());
                this.data2.rowX += dx;
                this.data2.rowWidth += dx;
                this.data2.rowHeight = Math.max(this.data2.rowHeight, r.height);
                this.data2.row[this.data2.rowCount] = f;
                this.data2.bounds[this.data2.rowCount] = r;
                ++this.data2.rowCount;
            }
            if (this.data2.rowCount != 0) {
                this.layoutRow(parent);
            }
            this.data2 = null;
        }

        protected void layoutRow(IFigure parent) {
            int majorAdjustment = 0;
            int minorAdjustment = 0;
            int correctMajorAlignment = this.getMajorAlignment();
            int correctMinorAlignment = this.getMinorAlignment();
            majorAdjustment = this.data2.area.width - this.data2.rowWidth + Math.max(this.getMinorSpacing(), this.getMinorSpacing2());
            switch (correctMajorAlignment) {
                case 1: {
                    majorAdjustment = 0;
                    break;
                }
                case 0: {
                    majorAdjustment /= 2;
                    break;
                }
            }
            int j = 0;
            while (j < this.data2.rowCount) {
                if (this.isStretchMinorAxis()) {
                    this.data2.bounds[j].height = this.data2.rowHeight;
                } else {
                    minorAdjustment = this.data2.rowHeight - this.data2.bounds[j].height;
                    switch (correctMinorAlignment) {
                        case 1: {
                            minorAdjustment = 0;
                            break;
                        }
                        case 0: {
                            minorAdjustment /= 2;
                            break;
                        }
                    }
                    this.data2.bounds[j].y += minorAdjustment;
                }
                this.data2.bounds[j].x += majorAdjustment;
                this.setBoundsOfChild(parent, this.data2.row[j], this.transposer.t(this.data2.bounds[j]));
                ++j;
            }
            this.data2.rowY += this.getMajorSpacing() + this.data2.rowHeight;
            this.initRow2();
        }

        private void initRow2() {
            this.data2.rowX = 0;
            this.data2.rowHeight = 0;
            this.data2.rowWidth = 0;
            this.data2.rowCount = 0;
        }

        private void initVariables2(IFigure parent) {
            this.data2.row = new IFigure[parent.getChildren().size()];
            this.data2.bounds = new Rectangle[this.data2.row.length];
            this.data2.maxWidth = this.data2.area.width;
        }

        private class WorkingData2 {
            public Rectangle[] bounds;
            public Rectangle area;
            public IFigure[] row;
            public int rowHeight;
            public int rowWidth;
            public int rowCount;
            public int rowX;
            public int rowY;
            public int maxWidth;

            private WorkingData2() {
            }
        }
    }
}

