/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.TaskMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DurationInfo
implements Comparable<DurationInfo> {
    public static final DurationInfo DEFAULT = new DurationInfo(1, 0);
    private int days;
    private int hours;
    private static final Pattern re = Pattern.compile("^\\s*(?:(\\d+)d)?(?:(\\d+)h)?\\s*$");

    public DurationInfo(int days, int hours) {
        this.days = days;
        this.hours = hours;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getTotalHours() {
        return this.days * 24 + this.hours;
    }

    @Override
    public int compareTo(DurationInfo that) {
        return this.getTotalHours() - that.getTotalHours();
    }

    public DateInfo addTo(DateInfo date) {
        if (date != null) {
            date.date.add(11, this.getTotalHours());
        }
        return date;
    }

    public DateInfo removeFrom(DateInfo date) {
        if (date != null) {
            date.date.add(11, -this.getTotalHours());
        }
        return date;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof DurationInfo)) {
            return false;
        }
        DurationInfo that = (DurationInfo)obj;
        return this.days == that.days && this.hours == that.hours;
    }

    public int hashCode() {
        return this.days ^ this.hours;
    }

    public String toString() {
        if (this.hours != 0) {
            if (this.days != 0) {
                return NLS.bind((String)TaskMessages.DurationFullFormat_pattern, (Object)this.days, (Object)this.hours);
            }
            return NLS.bind((String)TaskMessages.DurationHoursFormat_pattern, (Object)this.hours);
        }
        return NLS.bind((String)TaskMessages.DurationDaysFormat_pattern, (Object)this.days);
    }

    public String toTextContent() {
        if (this.hours != 0) {
            if (this.days != 0) {
                return String.format("%dd%dh", this.days, this.hours);
            }
            return String.format("%dh", this.hours);
        }
        return String.format("%dd", this.days);
    }

    public static DurationInfo parseDuration(String textContent) {
        if (textContent == null || "".equals(textContent)) {
            return null;
        }
        Matcher m = re.matcher(textContent);
        if (m.find()) {
            int days = DurationInfo.parseInt(m.group(1));
            int hours = DurationInfo.parseInt(m.group(2));
            if (days != 0 || hours != 0) {
                return new DurationInfo(days, hours);
            }
        }
        return null;
    }

    private static int parseInt(String v) {
        if (v != null) {
            try {
                return Integer.parseInt(v, 10);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public static DurationInfo calcDuration(DateInfo startDate, DateInfo endDate) {
        if (startDate == null || endDate == null) {
            return DEFAULT;
        }
        int seconds = (int)((endDate.date.getTimeInMillis() - startDate.date.getTimeInMillis() + 999L) / 1000L);
        int hours = seconds / 3600;
        int days = hours / 24;
        return new DurationInfo(days, hours -= days * 24);
    }

    public static DurationInfo calcDurationExcludeWeekends(DateInfo startDate, DateInfo endDate) {
        int delta;
        if (startDate == null || endDate == null) {
            return DEFAULT;
        }
        Calendar start = Calendar.getInstance();
        start.setTimeInMillis(startDate.date.getTimeInMillis());
        int startDayOfWeek = start.get(7);
        if (startDayOfWeek == 7 || startDayOfWeek == 1) {
            Calendar start2 = Calendar.getInstance();
            start2.set(start.get(1), start.get(2), start.get(5), 0, 0, 0);
            start2.getTime();
            start2.set(7, 2);
            if (start2.before(start)) {
                start2.add(3, 1);
            }
            start.setTimeInMillis(start2.getTimeInMillis());
        }
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(endDate.date.getTimeInMillis());
        int endDayOfWeek = end.get(7);
        if (endDayOfWeek == 7 || endDayOfWeek == 1) {
            Calendar end2 = Calendar.getInstance();
            end2.set(end.get(1), end.get(2), end.get(5), 0, 0, 0);
            end2.getTime();
            end2.set(7, 7);
            if (end2.getTimeInMillis() / 1000L / 86400L > end.getTimeInMillis() / 1000L / 86400L) {
                end2.add(3, -1);
            }
            end.setTimeInMillis(end2.getTimeInMillis());
        }
        int totalDays = (int)((end.getTimeInMillis() - start.getTimeInMillis()) / 1000L / 86400L);
        int weeks = totalDays / 7;
        int seconds = (int)((end.getTimeInMillis() - start.getTimeInMillis() + 999L) / 1000L) - (weeks += totalDays % 7 > (delta = 7 - start.get(7)) ? 1 : 0) * 172800;
        int hours = seconds / 3600;
        int days = hours / 24;
        if (days >= 0 && (hours -= days * 24) >= 0) {
            return new DurationInfo(days, hours);
        }
        return new DurationInfo(0, 0);
    }
}

