/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.gallery;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.core.internal.gallery.DownloadedGalleryItem;
import org.xmind.core.internal.gallery.GalleryCore;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.IGalleryItem;
import org.xmind.core.internal.gallery.LocalGalleryGroup;
import org.xmind.core.internal.gallery.LocalGalleryItem;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.gallery.GalleryPlugin;
import org.xmind.ui.internal.gallery.Messages;
import org.xmind.ui.internal.popover.PopoverMenuToolItem;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.viewers.ImageCachedLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClipArtPopoverMenuToolItem
extends PopoverMenuToolItem {
    private static final int GALLERY_ITEM_NUM = 20;

    protected void showExtensionControl(final Rectangle itemBoundsToDisplay) {
        VerifyUI20141031.runAction20141031((String)"ClipArtPopover", (String)Messages.ClipArtPopover_ClipArt_name, (int)7, (Runnable)new Runnable(){

            public void run() {
                ClipArtPopoverMenuToolItem.this.showExtensionShell(itemBoundsToDisplay);
            }
        }, null);
    }

    private void showExtensionShell(Rectangle itemBoundsToDisplay) {
        super.showExtensionControl(itemBoundsToDisplay);
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(composite2.getParent().getBackground());
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        composite2.setLayout((Layout)layout);
        this.createGalleryContainer(composite2);
        this.createSeperator(composite2);
        this.createHyperlinks(composite2);
        return composite;
    }

    private void createGalleryContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getParent().getBackground());
        GridData gridData = new GridData(4, 128, true, false);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 1;
        layout.marginHeight = 5;
        layout.marginTop = 5;
        composite.setLayout((Layout)layout);
        this.createGalleryViewer(composite);
    }

    private void createGalleryViewer(Composite parent) {
        GalleryViewer viewer = new GalleryViewer();
        EditDomain domain = new EditDomain();
        domain.installTool("select tool", (ITool)new GallerySelectTool());
        viewer.setEditDomain(domain);
        Properties properties = viewer.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
        properties.set("constrained", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(46, 46));
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(0, 0, 1, 1, new Insets(0)));
        properties.set("org.xmind.ui.gallery.singleClickToOpen", true);
        Control control = viewer.createControl(parent);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 320;
        control.setLayoutData((Object)gridData);
        viewer.setLabelProvider((IBaseLabelProvider)new GalleryLabelProvider());
        viewer.setInput(this.getInput());
        this.createDragSource(viewer);
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ClipArtPopoverMenuToolItem.this.insertImage(event.getSelection());
            }
        });
    }

    private void createSeperator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getParent().getBackground());
        GridData gridData = new GridData(4, 2, true, false);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 15;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Composite seperator = new Composite(composite, 0);
        seperator.setBackground(new LocalResourceManager(JFaceResources.getResources(), (Control)composite).createColor(ColorUtils.toRGB((String)"#cbcbcb")));
        GridData gridData2 = new GridData(4, 0x1000000, true, false);
        gridData2.heightHint = 1;
        seperator.setLayoutData((Object)gridData2);
        seperator.setLayout((Layout)new GridLayout());
    }

    private void createHyperlinks(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getParent().getBackground());
        GridData gridData = new GridData(4, 0x1000000, true, false);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 5;
        layout.marginBottom = 5;
        layout.verticalSpacing = 4;
        composite.setLayout((Layout)layout);
        this.createMoreClipArtHyperlink(composite);
        this.createManageClipArtHyperlink(composite);
    }

    private void createMoreClipArtHyperlink(Composite parent) {
        Hyperlink moreHyperlink = this.createHyperlink(parent, Messages.ClipArtPopover_MoreClipArt_label);
        moreHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                E4Utils.showPart((String)"org.xmind.ui.command.showModelPart", (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), (String)"org.xmind.ui.modelPart.image", (String)"org.xmind.ui.modelPart.image.pages.clipArt", (String)"org.xmind.ui.stack.right");
            }
        });
    }

    private void createManageClipArtHyperlink(Composite composite) {
        Hyperlink manageHyperlink = this.createHyperlink(composite, Messages.ClipArtPopover_ManageClipArt_label);
        manageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                E4Utils.showPart((String)"org.xmind.ui.command.showDialogPart", (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), (String)"org.xmind.ui.dialogPart.resourceManager", (String)"org.xmind.ui.dialogPart.resourceManager.clipArt", null);
            }
        });
    }

    private Hyperlink createHyperlink(Composite parent, String message) {
        Hyperlink hyperlink = new Hyperlink(parent, 4);
        hyperlink.setBackground(hyperlink.getParent().getBackground());
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        hyperlink.setLayoutData((Object)gridData);
        hyperlink.setUnderlined(false);
        hyperlink.setText(message);
        return hyperlink;
    }

    private List<IGalleryItem> getInput() {
        ArrayList<IGalleryItem> list = new ArrayList<IGalleryItem>();
        List<IGalleryGroup> groups = GalleryCore.getInstance().getGalleryGroups();
        for (IGalleryGroup group : groups) {
            if (!(group instanceof LocalGalleryGroup) || !group.getSymbolicName().equals("Office")) continue;
            int index = 0;
            while (index < 20 && index < group.getItems().size()) {
                list.add(group.getItems().get(index));
                ++index;
            }
        }
        return list;
    }

    private void insertImage(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IGraphicalEditorPage page;
            IEditorPart editor;
            IStructuredSelection ss = (IStructuredSelection)selection;
            ArrayList<String> paths = new ArrayList<String>(ss.size());
            Object[] objectArray = ss.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof LocalGalleryItem) {
                    paths.add(((LocalGalleryItem)o).getFile().getAbsolutePath());
                }
                if (o instanceof DownloadedGalleryItem) {
                    paths.add(((DownloadedGalleryItem)o).getPath());
                }
                ++n2;
            }
            if (!paths.isEmpty() && (editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) instanceof IGraphicalEditor && (page = ((IGraphicalEditor)editor).getActivePageInstance()) != null) {
                page.getEditDomain().handleRequest(new Request("add_image").setViewer((IViewer)page.getViewer()).setParameter("paths", (Object)paths.toArray(new String[paths.size()])));
            }
        }
    }

    private void createDragSource(final GalleryViewer viewer) {
        Control control = viewer.getControl();
        final DragSource dragSource = new DragSource(control, 1);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dragSource.dispose();
            }
        });
        dragSource.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            String[] sourceFiles;

            public void dragStart(DragSourceEvent event) {
                this.sourceFiles = this.getSelectedFiles();
                if (this.sourceFiles.length == 0) {
                    event.doit = false;
                }
            }

            private String[] getSelectedFiles() {
                ISelection selection = viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    ArrayList<String> files = new ArrayList<String>(ss.size());
                    for (Object o : ss.toList()) {
                        if (o instanceof LocalGalleryItem) {
                            files.add(((LocalGalleryItem)o).getFile().getAbsolutePath());
                        }
                        if (!(o instanceof DownloadedGalleryItem)) continue;
                        files.add(((DownloadedGalleryItem)o).getPath());
                    }
                    return files.toArray(new String[files.size()]);
                }
                return new String[0];
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = this.sourceFiles;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    private static class GalleryLabelProvider
    extends ImageCachedLabelProvider {
        private GalleryLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IGalleryGroup) {
                return ((IGalleryGroup)element).getName();
            }
            return super.getText(element);
        }

        protected Image createImage(Object element) {
            URL url;
            if (element instanceof IGalleryItem && (url = ((IGalleryItem)element).getURL()) != null) {
                Image image;
                InputStream stream = url.openStream();
                try {
                    image = new Image((Device)Display.getCurrent(), stream);
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        GalleryPlugin.log(e, "Failed to read image data from URL: " + url.toExternalForm());
                    }
                }
                stream.close();
                return image;
            }
            return null;
        }
    }
}

