/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.jvm.inspection.JvmToolchainMetadata;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;

@ServiceScope(value={Scopes.Build.class})
public class JavaInstallationRegistry {
    private final BuildOperationExecutor executor;
    private final Installations installations;
    private final JvmMetadataDetector metadataDetector;
    private final Logger logger;
    private final OperatingSystem os;
    private final ProgressLoggerFactory progressLoggerFactory;

    @Inject
    public JavaInstallationRegistry(List<InstallationSupplier> suppliers, JvmMetadataDetector metadataDetector, @Nullable BuildOperationExecutor executor, OperatingSystem os, ProgressLoggerFactory progressLoggerFactory) {
        this(suppliers, metadataDetector, Logging.getLogger(JavaInstallationRegistry.class), executor, os, progressLoggerFactory);
    }

    private JavaInstallationRegistry(List<InstallationSupplier> suppliers, JvmMetadataDetector metadataDetector, Logger logger, @Nullable BuildOperationExecutor executor, OperatingSystem os, ProgressLoggerFactory progressLoggerFactory) {
        this.logger = logger;
        this.executor = executor;
        this.metadataDetector = metadataDetector;
        this.installations = new Installations(() -> this.maybeCollectInBuildOperation(suppliers));
        this.os = os;
        this.progressLoggerFactory = progressLoggerFactory;
    }

    @VisibleForTesting
    static JavaInstallationRegistry withLogger(List<InstallationSupplier> suppliers, JvmMetadataDetector metadataDetector, Logger logger, BuildOperationExecutor executor, ProgressLoggerFactory progressLoggerFactory) {
        return new JavaInstallationRegistry(suppliers, metadataDetector, logger, executor, OperatingSystem.current(), progressLoggerFactory);
    }

    private Set<InstallationLocation> maybeCollectInBuildOperation(List<InstallationSupplier> suppliers) {
        if (this.executor != null) {
            return (Set)this.executor.call((CallableBuildOperation)new ToolchainDetectionBuildOperation(() -> this.collectInstallations(suppliers)));
        }
        return this.collectInstallations(suppliers);
    }

    protected Set<InstallationLocation> listInstallations() {
        return this.installations.get();
    }

    public List<JvmToolchainMetadata> toolchains() {
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(JavaInstallationRegistry.class).start("Discovering toolchains", "Discovering toolchains");
        List<JvmToolchainMetadata> result = this.listInstallations().parallelStream().peek(location -> progressLogger.progress("Extracting toolchain metadata from " + location.getDisplayName())).map(this::resolveMetadata).collect(Collectors.toList());
        progressLogger.completed();
        return result;
    }

    private JvmToolchainMetadata resolveMetadata(InstallationLocation location) {
        JvmInstallationMetadata metadata = this.metadataDetector.getMetadata(location);
        return new JvmToolchainMetadata(metadata, location);
    }

    public void addInstallation(InstallationLocation installation) {
        this.installations.add(installation);
    }

    private Set<InstallationLocation> collectInstallations(List<InstallationSupplier> suppliers) {
        return suppliers.parallelStream().peek(x -> this.logger.debug("Discovering toolchains provided via {}", (Object)x.getSourceName())).map(Supplier::get).flatMap(Collection::stream).filter(this::installationExists).map(this::canonicalize).map(this::maybeGetEnclosedInstallation).filter(this::installationHasExecutable).filter(JavaInstallationRegistry.distinctByKey(InstallationLocation::getLocation)).collect(Collectors.toSet());
    }

    protected boolean installationExists(InstallationLocation installationLocation) {
        File file = installationLocation.getLocation();
        if (!file.exists()) {
            this.logger.warn("Directory {} used for java installations does not exist", (Object)installationLocation.getDisplayName());
            return false;
        }
        if (!file.isDirectory()) {
            this.logger.warn("Path for java installation {} points to a file, not a directory", (Object)installationLocation.getDisplayName());
            return false;
        }
        return true;
    }

    protected boolean installationHasExecutable(InstallationLocation installationLocation) {
        if (!this.hasJavaExecutable(installationLocation.getLocation())) {
            this.logger.warn("Path for java installation {} does not contain a java executable", (Object)installationLocation.getDisplayName());
            return false;
        }
        return true;
    }

    private InstallationLocation canonicalize(InstallationLocation location) {
        File file = location.getLocation();
        try {
            File canonicalFile = file.getCanonicalFile();
            File javaHome = this.findJavaHome(canonicalFile);
            return new InstallationLocation(javaHome, location.getSource(), location.isAutoProvisioned());
        }
        catch (IOException e) {
            throw new GradleException(String.format("Could not canonicalize path to java installation: %s.", file), (Throwable)e);
        }
    }

    private InstallationLocation maybeGetEnclosedInstallation(InstallationLocation location) {
        File home = location.getLocation();
        File parentPath = home.getParentFile();
        boolean isEmbeddedJre = home.getName().equalsIgnoreCase("jre");
        if (isEmbeddedJre && this.hasJavaExecutable(parentPath)) {
            return new InstallationLocation(parentPath, location.getSource());
        }
        return location;
    }

    private File findJavaHome(File potentialHome) {
        if (this.os.isMacOsX() && new File(potentialHome, "Contents/Home").exists()) {
            return new File(potentialHome, "Contents/Home");
        }
        File standaloneJre = new File(potentialHome, "jre");
        if (!this.hasJavaExecutable(potentialHome) && this.hasJavaExecutable(standaloneJre)) {
            return standaloneJre;
        }
        return potentialHome;
    }

    private boolean hasJavaExecutable(File potentialHome) {
        return new File(potentialHome, this.os.getExecutableName("bin/java")).exists();
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    private static class Installations {
        private final Supplier<Set<InstallationLocation>> initializer;
        private Set<InstallationLocation> locations = null;

        Installations(Supplier<Set<InstallationLocation>> initializer) {
            this.initializer = initializer;
        }

        synchronized Set<InstallationLocation> get() {
            this.initIfNeeded();
            return this.locations;
        }

        synchronized void add(InstallationLocation location) {
            this.initIfNeeded();
            this.locations.add(location);
        }

        private void initIfNeeded() {
            if (this.locations == null) {
                this.locations = this.initializer.get();
            }
        }
    }

    private static class ToolchainDetectionBuildOperation
    implements CallableBuildOperation<Set<InstallationLocation>> {
        private final Callable<Set<InstallationLocation>> detectionStrategy;

        public ToolchainDetectionBuildOperation(Callable<Set<InstallationLocation>> detectionStrategy) {
            this.detectionStrategy = detectionStrategy;
        }

        public Set<InstallationLocation> call(BuildOperationContext context) throws Exception {
            return this.detectionStrategy.call();
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)"Toolchain detection").progressDisplayName("Detecting local java toolchains");
        }
    }
}

