/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import javax.inject.Inject;
import org.gradle.api.internal.artifacts.ResolveArtifactsBuildOperationType;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DependencyVerificationOverride;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ParallelResolveArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.work.WorkerLeaseService;

public class ResolvedArtifactSetResolver {
    private final WorkerLeaseService workerLeaseService;
    private final BuildOperationExecutor buildOperationExecutor;
    private final DependencyVerificationOverride dependencyVerificationOverride;

    @Inject
    public ResolvedArtifactSetResolver(WorkerLeaseService workerLeaseService, BuildOperationExecutor buildOperationExecutor, DependencyVerificationOverride dependencyVerificationOverride) {
        this.workerLeaseService = workerLeaseService;
        this.buildOperationExecutor = buildOperationExecutor;
        this.dependencyVerificationOverride = dependencyVerificationOverride;
    }

    public void visitInUnmanagedWorkerThread(ResolvedArtifactSet artifacts, ArtifactVisitor visitor, ResolutionHost resolutionHost) {
        this.workerLeaseService.runAsUnmanagedWorkerThread(() -> this.visitArtifacts(artifacts, visitor, resolutionHost));
    }

    public void visitArtifacts(final ResolvedArtifactSet artifacts, final ArtifactVisitor visitor, final ResolutionHost resolutionHost) {
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                ParallelResolveArtifactSet.wrap(artifacts, ResolvedArtifactSetResolver.this.buildOperationExecutor).visit(visitor);
                ResolvedArtifactSetResolver.this.dependencyVerificationOverride.artifactsAccessed(resolutionHost.getDisplayName());
                context.setResult((Object)new ResolveArtifactsBuildOperationType.Result(){});
            }

            public BuildOperationDescriptor.Builder description() {
                String displayName = "Resolve files of " + resolutionHost.getDisplayName();
                return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName).details((Object)new ResolveArtifactsBuildOperationType.Details(){

                    @Deprecated
                    public String getConfigurationPath() {
                        return "";
                    }
                });
            }
        });
    }
}

