/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.application.tasks;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.plugins.StartScriptGenerator;
import org.gradle.api.internal.plugins.UnixStartScriptGenerator;
import org.gradle.api.internal.plugins.WindowsStartScriptGenerator;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.jvm.application.scripts.ScriptGenerator;
import org.gradle.util.internal.GUtil;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class CreateStartScripts
extends ConventionTask {
    private File outputDir;
    private String executableDir = "bin";
    private final Property<String> mainModule;
    private final Property<String> mainClass;
    private Iterable<String> defaultJvmOpts = new LinkedList<String>();
    private String applicationName;
    private String optsEnvironmentVar;
    private String exitEnvironmentVar;
    private FileCollection classpath;
    private final ModularitySpec modularity;
    private ScriptGenerator unixStartScriptGenerator = new UnixStartScriptGenerator();
    private ScriptGenerator windowsStartScriptGenerator = new WindowsStartScriptGenerator();

    public CreateStartScripts() {
        this.mainModule = this.getObjectFactory().property(String.class);
        this.mainClass = this.getObjectFactory().property(String.class);
        this.modularity = (ModularitySpec)this.getObjectFactory().newInstance(DefaultModularitySpec.class, new Object[0]);
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaModuleDetector getJavaModuleDetector() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    @Optional
    @Input
    public String getOptsEnvironmentVar() {
        if (GUtil.isTrue((Object)this.optsEnvironmentVar)) {
            return this.optsEnvironmentVar;
        }
        if (!GUtil.isTrue((Object)this.getApplicationName())) {
            return null;
        }
        return GUtil.toConstant((CharSequence)this.getApplicationName()) + "_OPTS";
    }

    @Nullable
    @Optional
    @Input
    public String getExitEnvironmentVar() {
        if (GUtil.isTrue((Object)this.exitEnvironmentVar)) {
            return this.exitEnvironmentVar;
        }
        if (!GUtil.isTrue((Object)this.getApplicationName())) {
            return null;
        }
        return GUtil.toConstant((CharSequence)this.getApplicationName()) + "_EXIT_CONSOLE";
    }

    @Internal
    public File getUnixScript() {
        return new File(this.getOutputDir(), this.getApplicationName());
    }

    @Internal
    public File getWindowsScript() {
        return new File(this.getOutputDir(), this.getApplicationName() + ".bat");
    }

    @OutputDirectory
    @Nullable
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(@Nullable File outputDir) {
        this.outputDir = outputDir;
    }

    @Input
    public String getExecutableDir() {
        return this.executableDir;
    }

    public void setExecutableDir(String executableDir) {
        this.executableDir = executableDir;
    }

    @Optional
    @Input
    public Property<String> getMainModule() {
        return this.mainModule;
    }

    @Optional
    @Input
    public Property<String> getMainClass() {
        return this.mainClass;
    }

    @Input
    @Optional
    @Nullable
    @Deprecated
    public String getMainClassName() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(CreateStartScripts.class, (String)"mainClassName").replaceWith((Object)"mainClass")).willBeRemovedInGradle9().withDslReference().nagUser();
        return (String)this.mainClass.getOrNull();
    }

    @Deprecated
    public void setMainClassName(@Nullable String mainClassName) {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(CreateStartScripts.class, (String)"mainClassName").replaceWith((Object)"mainClass")).willBeRemovedInGradle9().withDslReference().nagUser();
        this.mainClass.set((Object)mainClassName);
    }

    @Nullable
    @Optional
    @Input
    public Iterable<String> getDefaultJvmOpts() {
        return this.defaultJvmOpts;
    }

    public void setDefaultJvmOpts(@Nullable Iterable<String> defaultJvmOpts) {
        this.defaultJvmOpts = defaultJvmOpts;
    }

    @Nullable
    @Input
    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(@Nullable String applicationName) {
        this.applicationName = applicationName;
    }

    public void setOptsEnvironmentVar(@Nullable String optsEnvironmentVar) {
        this.optsEnvironmentVar = optsEnvironmentVar;
    }

    public void setExitEnvironmentVar(@Nullable String exitEnvironmentVar) {
        this.exitEnvironmentVar = exitEnvironmentVar;
    }

    @Nullable
    @Classpath
    @Optional
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Nested
    public ModularitySpec getModularity() {
        return this.modularity;
    }

    public void setClasspath(@Nullable FileCollection classpath) {
        this.classpath = classpath;
    }

    @Internal
    public ScriptGenerator getUnixStartScriptGenerator() {
        return this.unixStartScriptGenerator;
    }

    public void setUnixStartScriptGenerator(ScriptGenerator unixStartScriptGenerator) {
        this.unixStartScriptGenerator = unixStartScriptGenerator;
    }

    @Internal
    public ScriptGenerator getWindowsStartScriptGenerator() {
        return this.windowsStartScriptGenerator;
    }

    public void setWindowsStartScriptGenerator(ScriptGenerator windowsStartScriptGenerator) {
        this.windowsStartScriptGenerator = windowsStartScriptGenerator;
    }

    @TaskAction
    public void generate() {
        StartScriptGenerator generator = new StartScriptGenerator(this.unixStartScriptGenerator, this.windowsStartScriptGenerator);
        JavaModuleDetector javaModuleDetector = this.getJavaModuleDetector();
        generator.setApplicationName(this.getApplicationName());
        generator.setMainClassName(this.fullMainArgument());
        generator.setDefaultJvmOpts(this.getDefaultJvmOpts());
        generator.setOptsEnvironmentVar(this.getOptsEnvironmentVar());
        generator.setExitEnvironmentVar(this.getExitEnvironmentVar());
        generator.setClasspath(this.getRelativePath(javaModuleDetector.inferClasspath(this.mainModule.isPresent(), this.getClasspath())));
        generator.setModulePath(this.getRelativePath(javaModuleDetector.inferModulePath(this.mainModule.isPresent(), this.getClasspath())));
        if (StringUtils.isEmpty((String)this.getExecutableDir())) {
            generator.setScriptRelPath(this.getUnixScript().getName());
        } else {
            generator.setScriptRelPath(this.getExecutableDir() + "/" + this.getUnixScript().getName());
        }
        generator.generateUnixScript(this.getUnixScript());
        generator.generateWindowsScript(this.getWindowsScript());
    }

    private String fullMainArgument() {
        String main = "";
        if (this.mainModule.isPresent()) {
            main = main + "--module ";
            main = main + (String)this.mainModule.get();
            if (this.mainClass.isPresent()) {
                main = main + "/";
            }
        }
        if (this.mainClass.isPresent()) {
            main = main + (String)this.mainClass.get();
        }
        return main;
    }

    @Input
    protected Iterable<String> getRelativeClasspath() {
        FileCollection classpathNullable = this.getClasspath();
        if (classpathNullable == null) {
            return Collections.emptyList();
        }
        return this.getRelativePath(classpathNullable);
    }

    private Iterable<String> getRelativePath(FileCollection path) {
        return path.getFiles().stream().map(input -> "lib/" + input.getName()).collect(Collectors.toCollection(Lists::newArrayList));
    }
}

