# GNU Enterprise Application Server - List Object
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: geasConfiguration.py 9953 2009-10-11 18:50:17Z reinhard $

import os.path

from gnue import paths
from gnue.common.apps.i18n import utranslate as u_      # for epydoc
from gnue.common.formatting import GTypecast


ConfigOptions = (

  { 'Name'       : 'database',
    'Type'       : 'Setting',
    'Comment'    : u_("Depreciated: Name of the database connection appserver "
                      "is using. Use connection instead."),
    'Description': u_("Depreciated: Name of the database connection appserver "
                      "is using. Use connection instead."),
    'Typecast'   : GTypecast.text,
    'Default'    : ''},

  { 'Name'       : 'connection',
    'Type'       : 'Setting',
    'Comment'    : u_("Name of the database connection appserver is using"),
    'Description': u_("Name of the database connection appserver is using"),
    'Typecast'   : GTypecast.text,
    'Default'    : 'gnue' },

  { 'Name'       : 'rpctype',
    'Type'       : 'Setting',
    'Comment'    : u_('RPC Interface Type appserver is providing'),
    'Description': u_('RPC Interface Type appserver is providing'),
    'Typecast'   : GTypecast.text,
    'Default'    : 'xmlrpc' },

  { 'Name'       : 'rpcport',
    'Type'       : 'Setting',
    'Comment'    : u_('Port (if needed) for RPC Interface'),
    'Description': u_('Port (if needed) for RPC Interface'),
    'Typecast'   : GTypecast.whole,
    'Default'    : '8765' },

  { 'Name'       : 'allowed_hosts',
    'Type'       : 'Setting',
    'Comment'    : u_('Hosts which are allowed to access appserver'),
    'Description': u_('Hosts which are allowed to access appserver'),
    'Typecast'   : GTypecast.text,
    'Default'    : '' },

  { 'Name'       : 'bindto',
    'Type'       : 'Setting',
    'Comment'    : u_('Hostname of the interface to bind services to'),
    'Description': u_('Hostname of the interface to bind services to'),
    'Typecast'   : GTypecast.text,
    'Default'    : '' },

  { 'Name'       : 'null_first_asc',
    'Type'       : 'Setting',
    'Comment'    : u_('Null values appear first in ascending sort'),
    'Description': u_('Null values appear first in ascending sort'),
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

  { 'Name'       : 'null_first_dsc',
    'Type'       : 'Setting',
    'Comment'    : u_('Null values appear first in descending sort'),
    'Description': u_('Null values appear first in descending sort'),
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

  { 'Name'       : 'modulepath',
    'Type'       : 'Setting',
    'Comment'    : u_('Semicolon-separated list of paths to load modules from'),
    'Description': u_('Semicolon-separated list of paths to load modules from'),
    'Typecast'   : GTypecast.text,
    'Default'    : os.path.join (paths.data, "share", "gnue", "appserver") },

  { 'Name'       : 'uuidtype',
    'Type'       : 'Setting',
    'Comment'    : u_("Type of UUID to use. Can be 'time' or 'random'"),
    'Description': u_("Type of UUID to use. Can be 'time' or 'random'"),
    'Typecast'   : GTypecast.text,
    'Default'    : 'time' },

  { 'Name'       : 'httpdir',
    'Type'       : 'Setting',
    'Comment'    : u_('Directory for webfrontend http documents'),
    'Description': u_('Directory for webfrontend http documents'),
    'Typecast'   : GTypecast.text,
    'Default'    : "/this_dir_shouldn't exist." }, # default should be overridden
  { 'Name'       : 'servertype',
    'Type'       : 'Setting',
    'Comment'    : u_("Type of the HTTP server to use. Can be 'threading' or " \
                      "'forking'"),
    'Description': u_("Type of the HTTP server to use. Can be 'threading' or " \
                      "'forking'"),
    'Typecast'   : GTypecast.text,
    'Default'    : 'forking' },
)
