#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2007 Free Software Foundation
#
# FILE:
# MsgBoxYesNo.py
#
# DESCRIPTION:
#
# NOTES:
#



# TODO: this looks strangely like another MsgBox class -- is it really
# needed?

from constants import *
from Button import Button
from Label import Label
from Dialog import Dialog

class MsgBoxYesNo(Dialog):
  """ a small dialog ask yes/no questions
  """
  def __init__(self, Parent, Message, **properties):
    SIOInstance = Parent.Screen()
    sMCOL = SIOInstance.MAXCOL
    sMROW = SIOInstance.MAXROW
    MsgLen = len(Message)
    DialogWidth = MsgLen + 4
    DialogHeight = 6

    if DialogWidth < 12:
      DialogWidth = 18
  
    r1 = (sMROW - DialogHeight) / 2
    r2 = r1 + DialogHeight

    c1 = (sMCOL - DialogWidth) / 2
    c2 = c1 + DialogWidth

    Dialog.__init__(self, Parent, r1, c1, r2, c2, **properties)
    tCmdYes = Button(self, "YesBtn", 5, (DialogWidth - 7) / 4, 7, "Yes")
    tCmdYes.EXITFORM = 1
    self.AddDialogControl(tCmdYes)
    tCmdNo = Button(self, "NoBtn", 5, 2 + (2 * ((DialogWidth - 7)) / 4), 7, "No")
    tCmdNo.EXITFORM = 1
    self.AddDialogControl(tCmdNo)
    self.AddDialogControl(Label(self, "TheMsg", 1, 2, Message))

  def Show(self):
    self.Screen().LoLight()
    t = self.RunDialog()
    return t


#
# Menu-System (Items, Menus, MenuBar)
#
 

