; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
AppId=GNUe-Forms
AppName=GNU Enterprise Forms
AppVerName=GNU Enterprise Forms 0.6.3
AppPublisher=GNU Enterprise
AppPublisherURL=http://www.gnuenterprise.org
AppSupportURL=http://www.gnuenterprise.org
AppUpdatesURL=http://www.gnuenterprise.org
DefaultDirName={pf}\GNUe\
DefaultGroupName=GNUe
AllowNoIcons=true
LicenseFile=
ChangesAssociations=true
CreateAppDir=true
ShowLanguageDialog=yes
OutputDir=C:\GNUE\dist
OutputBaseFilename=gnue-forms-0.6.3
DisableDirPage=true
AppendDefaultDirName=false

[Tasks]

[Components]
Name: main; Description: Shared Program Files; Types: full compact custom; Flags: fixed
Name: doc; Description: Documentation; Types: full
Name: translations; Description: Translations; Types: full

[Files]
Source: c:\gnue\bin\gnue-forms.exe; DestDir: {app}\bin; Components: main; Flags: ignoreversion
Source: c:\gnue\bin\gnue\forms\*.*; DestDir: {app}\bin\gnue\forms; Flags: recursesubdirs ignoreversion; Components: main
Source: c:\gnue\share\locale\gnue-forms.mo; DestDir: {app}\share\locale\; Flags: recursesubdirs createallsubdirs; Components: translations
Source: c:\gnue\share\doc\gnue-forms\*.*; DestDir: {app}\share\doc\gnue-forms; Flags: recursesubdirs; Components: doc
Source: c:\gnue\share\gnue\*.*; DestDir: {app}\share\gnue\; Components: main; Flags: recursesubdirs createallsubdirs

[Icons]

[Registry]
; These four associations associate GFD files with GNUe Forms
Root: HKCR; Subkey: .gfd; ValueType: string; ValueName: ; ValueData: GNUeFormsClient; Flags: uninsdeletekey deletekey
Root: HKCR; Subkey: GNUeFormsClient; ValueType: string; ValueName: ; ValueData: GNUe Form Definition; Flags: uninsdeletekey deletekey
;when we get a nifty icon, that's set here :)
Root: HKCR; Subkey: GNUeFormsClient\DefaultIcon; ValueType: string; ValueName: ; ValueData: {app}\bin\GNUE-FORMS.EXE,0
Root: HKCR; Subkey: GNUeFormsClient\shell\open\command; ValueType: string; ValueName: ; ValueData: """{app}\bin\GNUE-FORMS.EXE"" ""%1"""; Flags: deletekey

[UninstallDelete]
Name: {app}\bin\gnue\forms\*.*; Type: filesandordirs

[Code]
function GetPathInstalled(AppID: String): String;
var
   sPrevPath: String;
begin
  sPrevPath := '';
  if not RegQueryStringValue( HKLM,
    'Software\Microsoft\Windows\CurrentVersion\Uninstall\'+AppID+'_is1',
    'Inno Setup: App Path', sPrevpath) then
    RegQueryStringValue( HKCU, 'Software\Microsoft\Windows\CurrentVersion\Uninstall\'+AppID+'_is1' ,
      'Inno Setup: App Path', sPrevpath);

  Result := sPrevPath;
end;


function InitializeSetup(): Boolean;
var
	sPrevPath: String;
	sPrevID: String;
begin
  sPrevID := 'GNUe-Tools';
  sPrevPath := GetPathInstalled( sprevID );

  if ( Length(sPrevPath) > 0 ) then
    Result := true
  else
    begin
      MsgBox( 'GNUe-Runtime-Environment is not installed!', mbInformation, MB_OK );
      Result := false;
    end;

  if (Length(GetPathInstalled('GNUe-Common')) > 0) then
      Result := true
  else begin
      MsgBox('GNUe-Common is not installed!  Please install the GNUe-Common package in order to setup GNUe-Forms.', mbInformation, MB_OK);
      Result := false;
  end;
end;
