# GNU Enterprise Forms - wx 2.6 UI Driver - Toolbar widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: toolbar.py 9364 2007-02-09 11:17:51Z reinhard $

import gtk

from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper


# =============================================================================
# Wrap an UI layer around a wxMenu widget
# =============================================================================

class UIToolbar(UIHelper):
    """
    Implements a toolbar object.
    """

    # -------------------------------------------------------------------------
    # Create a menu widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):
        """
        Creates a new toolbar widget.
        """

        widget = None

        if self._gfObject.name == '__main_toolbar__' \
                and not self._form._features['GUI:TOOLBAR:SUPPRESS']:

            handlebox = gtk.HandleBox()
            widget = gtk.Toolbar()

            widget.set_orientation(gtk.ORIENTATION_HORIZONTAL)
            widget.set_style(gtk.TOOLBAR_ICONS)
            widget.set_tooltips(True)
            handlebox.add(widget)

            self._uiForm.content_table.attach(handlebox,
                  # X direction            Y direction
                    0, 1,                  1, 2,
                    gtk.EXPAND | gtk.FILL, 0,
                    0,                     0)

            if not hasattr(self._uiForm,"_tooltips"):
                self._uiForm._tooltips = gtk.Tooltips()

        self._container = widget

        return widget


# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass': UIToolbar,
  'provides' : 'GFToolbar',
  'container': 1,
}
