# GNU Enterprise Forms - QT3 UI Driver - Basic UI widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: _base.py 10007 2009-10-26 21:19:19Z reinhard $

import qt

from gnue.forms.uidrivers._base.widgets._base import UIWidget

__all__ = ['UIHelper']

# =============================================================================
# Base class for all qt3 UI widgets 
# =============================================================================

class UIHelper(UIWidget):
    """
    Implements the common behaviour of qt3 UI widgets
    """

    growable = False

    # -------------------------------------------------------------------------
    # Constructor
    # -------------------------------------------------------------------------

    def __init__(self, event):

        UIWidget.__init__(self, event)

        self.widget = None
        self.label = None


    # -------------------------------------------------------------------------
    # Focus handling
    # -------------------------------------------------------------------------

    def _ui_set_focus_(self, index):

        widget = self.widgets[index]
        if widget:
            widget.setFocus()

    # -------------------------------------------------------------------------

    def _ui_focus_in_(self, index):

        widget = self.widgets[index]
        if self.in_grid and widget._gnue_label_:
            label = widget._gnue_label_
            widget.show()
            label.hide()


    # -------------------------------------------------------------------------

    def _ui_focus_out_(self, index):

        widget = self.widgets[index]
        if self.in_grid and widget._gnue_label_:
            label = widget._gnue_label_
            label.show()
            widget.hide()

    # -------------------------------------------------------------------------

    def _ui_set_current_row_(self, index):
      
        pass



# =============================================================================
# Base class for H/V-Boxes in a managed layout
# =============================================================================

class ManagedBox(UIHelper):
    """
    """

    growable   = True
    _vertical_ = True
    _entry_pos = 0
    last_item  = 0

    # -------------------------------------------------------------------------
    # Create the widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):
        """
        """

        self._container = self.widget = qt.QGroupBox(event.container)
        if self._gfObject.label is not None:
            self._container.setTitle(self._gfObject.label)

        self._container.setInsideMargin(6)

        if self._vertical_:
            self.sizer = qt.QGridLayout(1, 2, 2)
        else:
            self.sizer = qt.QGridLayout(2, 1, 2)

        self._entry_pos = self.__need_both() and 2 or 1

        if self._vertical_:
            self.sizer.setColStretch(self._entry_pos - 1, 1)
        else:
            self.sizer.setRowStretch(self._entry_pos - 1, 1)

        self._container.layout().addLayout(self.sizer)
        self.getParent().add_widgets(self, 0)

        self.last_item = 0


    # -------------------------------------------------------------------------
    # Does this box need both columns or rows ?
    # -------------------------------------------------------------------------

    def __need_both(self):

        result = False

        for item in self._children:
            if (item._gfObject._type in ['GFEntry', 'GFImage']) and \
                    item._gfObject.label:
                result = True
                break

        return result
