# GNU Enterprise Forms - QT3 UI Driver - Box widgets
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: box.py 9956 2009-10-11 18:54:57Z reinhard $

from PyQt4 import Qt as qt

from gnue.forms.uidrivers.qt4.widgets._base import UIHelper

__all__ = ['UIBox']

# =============================================================================
# The Box Widget
# =============================================================================

class UIBox(UIHelper):
    """
    Implementation of the box tag
    """

    # -------------------------------------------------------------------------
    # Create the widget
    # -------------------------------------------------------------------------
    
    def _create_widget_(self, event, spacer):
        """
        Create the QGroupBox and add it to the owner

        @param event: the creation event instance
        """
    
        self._container = qt.QGroupBox(self._gfObject.label, event.container)
##        self._container.setInsideMargin(6)
        self.widget = self._container

        self.sizer = qt.QGridLayout(self.widget)

        self.getParent().add_widgets(self, 0)
        
        return self._container


    # -------------------------------------------------------------------------
    # Add child widgets (qt) to the layout
    # -------------------------------------------------------------------------

    def add_widgets(self, ui_widget, spacer):
        """
        Add a given UI-widget to the QGridLayout of the box

        @param ui_widget: UI widget to add
        @param spacer: not used for boxes
        """

        item = ui_widget.widget

        self.sizer.addWidget(item, ui_widget.chr_y,
                ui_widget.chr_x, ui_widget.chr_h, ui_widget.chr_w)




# =============================================================================
# Configuration
# =============================================================================

configuration = {
  'baseClass': UIBox,
  'provides' : 'GFBox',
  'container': 0,
}
