# GNU Enterprise Forms - win32 UI Driver - Toolbar widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: toolbar.py 9956 2009-10-11 18:54:57Z reinhard $

import struct

import win32api
import win32con
import win32gui
import commctrl

from gnue.forms.uidrivers.win32.widgets._base import UIHelper, Win32Window
from gnue.forms.uidrivers.win32.common import getNextId, textEncode


# =============================================================================
# Wrap an UI layer around a wxMenu widget
# =============================================================================

class UIToolbar(UIHelper):
    """
    Implements a toolbar object.
    """

    # -------------------------------------------------------------------------
    # Create a menu widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):
        """
        Creates a new toolbar widget.
        """

        widget = self._container = None

        if self._gfObject.name == '__main_toolbar__' \
                and not self._form._features['GUI:TOOLBAR:SUPPRESS']:

            self.hinst = win32api.GetModuleHandle(None)
            style = win32con.WS_CHILD | commctrl.TBSTYLE_TOOLTIPS | commctrl.TBSTYLE_FLAT #|win32con.WS_BORDER
            styleEx = 0
            widget = self.toolbar = mainToolBar = Win32Window(self._uiForm.mainWindow._uiDriver, styleEx, commctrl.TOOLBARCLASSNAME, "GNUe toolbar",
              style, 0, 0, 0, 0,
              self._uiForm.mainWindow, getNextId(), self.hinst)

            style = win32con.WS_CHILD | win32con.SS_SUNKEN
            Win32Window(self._uiForm.mainWindow._uiDriver, 0, 'STATIC', '', style, 0, 30, 9999, 2, mainToolBar)
        
            self.himl = himl = win32gui.ImageList_Create(24, 24, commctrl.ILC_COLOR32, 0, 3)

            tbab = struct.pack("ii", 0, himl)
            win32gui.SendMessage(mainToolBar.GetHwnd(), commctrl.TB_SETIMAGELIST, 0, himl)

            self._htt = win32gui.SendMessage(mainToolBar.GetHwnd(), commctrl.TB_GETTOOLTIPS, 0, 0)
            win32gui.SendMessage(self._htt, commctrl.TTM_SETMAXTIPWIDTH , 0, 250)

            self._buttonCount = 0
            win32gui.SendMessage(mainToolBar.GetHwnd(), commctrl.TB_AUTOSIZE, 0, 0)
            mainToolBar.Show()
            
            self._container = self
        return widget


# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass': UIToolbar,
  'provides' : 'GFToolbar',
  'container': 1,
}
