#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: GNConfig.py 9957 2009-10-11 18:55:59Z reinhard $

"""
Valid configuration options for navigator
(appears under [navigator] section in gnue.conf)
"""

from gnue.common.formatting import GTypecast

ConfigOptions = (
  { 'Name'       : 'RunFormCommand',
    'Type'       : 'Setting',
    'Comment'    : 'Command to execute on .gfd files.',
    'Description': 'Command to execute on .gfd files.',
    'Typecast'   : GTypecast.text,
    'Default'    : 'gnue-forms' },

  { 'Name'       : 'RunReportCommand',
    'Type'       : 'Setting',
    'Comment'    : 'Command to execute on .grd files.',
    'Description': 'Command to execute on .grd files.',
    'Typecast'   : GTypecast.text,
    'Default'    : 'gnue-reports' },

  { 'Name'       : 'FormDir',
    'Type'       : 'Setting',
    'Comment'    : 'Directory to search for .gfd files.',
    'Description': 'Directory to search for .gfd files.',
    'Typecast'   : GTypecast.text,
    'Default'    : 'forms' },

  { 'Name'       : 'ReportDir',
    'Type'       : 'Setting',
    'Comment'    : 'Directory to search for .grd files.',
    'Description': 'Directory to search for .grd files.',
    'Typecast'   : GTypecast.text,
    'Default'    : 'reports' },

  { 'Name'       : 'ProcessDir',
    'Type'       : 'Setting',
    'Comment'    : 'Directory to search for .gpd files.',
    'Description': 'Directory to search for .gpd files.',
    'Typecast'   : GTypecast.text,
    'Default'    : 'navigator' },
  
  { 'Name'       : 'embedForms',
    'Type'       : 'Setting',
    'Comment'    : "Do not open separate window to display a GNUe Form.",
    'Description': "Do not open separate window to display a GNUe Form.",
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

  { 'Name'       : 'hourglassDelay',
    'Type'       : 'Setting',
    'Comment'    : 'The number of seconds to display the hourglass '
                 + 'when launching a program.',
    'Description': 'The number of seconds to display the hourglass '
                 + 'when launching a program.',
    'Typecast'   : GTypecast.whole,
    'Default'    : 5 },
)
