<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:gnue="GNUe:Reports:Base"
  xmlns:t="GNUe:Reports:SimpleTabulation"
  version="1.0">

<xsl:output method="text" indent="no"/>


<xsl:template name="normalize_quotes">
  <xsl:param name="text"/>
  <xsl:choose>
    <xsl:when test="contains($text,'&quot;')">
      <xsl:value-of select="substring-before($text,'&quot;')"/>
      <xsl:text>&quot;&quot;</xsl:text>
      <xsl:call-template name="normalize_quotes">
        <xsl:with-param name="text" select="substring-after($text,'&quot;')"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$text"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template match="/">
  <xsl:variable name="newline">
<xsl:text>
</xsl:text>
  </xsl:variable>
  <xsl:variable name="tab">
<xsl:text>&#009;</xsl:text>
  </xsl:variable>

  <xsl:variable name="quote"><xsl:text>"</xsl:text></xsl:variable>
  <xsl:variable name="sep"><xsl:text>,</xsl:text></xsl:variable>

  <xsl:for-each select="gnue:report-output/t:report/t:section">
    <xsl:for-each select="t:table">
      <xsl:for-each select="t:tablehead">
        <xsl:variable name="repeat" select="'0'"/>
        <xsl:for-each select="t:colhead">
          <xsl:if test="position() &gt; 1">
            <xsl:value-of select="$sep"/>
          </xsl:if>
          <xsl:value-of select="$quote"/>
          <xsl:call-template name="normalize_quotes">
            <xsl:with-param name="text" select="."/>
          </xsl:call-template>
          <xsl:value-of select="$quote"/>
        </xsl:for-each>
        <xsl:value-of select="$newline"/>
      </xsl:for-each>
      <xsl:for-each select="t:row">
        <xsl:for-each select="t:col">
          <xsl:if test="position() &gt; 1">
            <xsl:value-of select="$sep"/>
          </xsl:if>
          <xsl:value-of select="$quote"/>
          <xsl:call-template name="normalize_quotes">
            <xsl:with-param name="text" select="."/>
          </xsl:call-template>
          <xsl:value-of select="$quote"/>
        </xsl:for-each>
        <xsl:value-of select="$newline"/>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:for-each>
</xsl:template>
</xsl:stylesheet>
