/*
 *  css.h
 *
 *  Copyright (C) 2011 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __CSS_H
#define __CSS_H

#define CSS_MAGIC			0xDADADADA
#define CSS_IMG_VERSION			0x0100
#define CSS_ABI_VERSION			0x0100

/* css resource indices */
#define CSS_AHBRAM				0
#define CSS_ITCM				1
#define CSS_DTCM				2

struct boot_config {
	unsigned long dram_addr;
	unsigned long dram_size;
	int uart;
};

struct css_img_hdr {
	unsigned long magic;
	unsigned long parts;
	unsigned long dc_addr;
	unsigned long boot_config;
	unsigned long elf_md5_addr;
	u16 abi_version;
	u16 img_version;
	char info[52];
} __attribute__((__packed__));

struct css_part_hdr {
	unsigned long size;
	unsigned long rsize;
	unsigned long dest_addr;
	unsigned char md5[16];
} __attribute__((__packed__));

struct css_pdata {
	unsigned rf_reset;	/* RF reset GPIO - set to -1 if not used */
	int uart;		/* CSS debug UART - set to -1 if not available */
};

#define CSS_FIRMWARE_NA				0
#define CSS_FIRMWARE_PENDING			1
#define CSS_FIRMWARE_LOADED			2
#define CSS_FIRMWARE_PANIC			3

enum css_dev_clocks {
	CSS_CLK_ADPCM,
	CSS_CLK_BMP,
	CSS_CLK_GDMAC,
	CSS_CLK_TIMER1,
	CSS_CLK_TIMER2,
	CSS_CLK_UART,
	CSS_CLK_RTC,
	CSS_CLK_TUNE,
	_CSS_CLK_LAST,
};

#define CSS_CLK_REQ_ENABLE		0
#define CSS_CLK_REQ_DISABLE		1
#define CSS_CLK_REQ_SET_RATE		2
#define CSS_CLK_REQ_GET_RATE		3
#define CSS_CLK_REQ_ROUND_RATE		4

enum css_dev_resets {
	CSS_RST_ADPCM,
	CSS_RST_BMP,
	CSS_RST_GDMAC,
	CSS_RST_TIMERS,
	CSS_RST_UART,
	_CSS_RST_LAST,
};

#define CSS_RST_REQ_ENABLE		0
#define CSS_RST_REQ_DISABLE		1

#endif
