#ifndef __LINUX_DRIVERS_MFD_DP52_PMU_H
#define __LINUX_DRIVERS_MFD_DP52_PMU_H

#include <linux/mutex.h>

struct device;
struct spi_device;
struct dp52_platform_data;
struct dentry;

struct dp52 {
	struct spi_device		*spi;

	int irq;  /* our external IRQ */
	struct mutex irq_lock;
	unsigned int irq_base; /* base of child IRQs */
	int irq_enable_cur;   /* Currently active value */
	int irq_enable_cache; /* Cached hardware value */
	int irq_enable_wake; /* Wakeup enabled IRQs */

	int aux_bgp;
	int dcin3_gain;
	int dcin3_attn;

	struct mutex mutex_auxilary;
	struct mutex mutex_indirect;
	struct mutex mutex_rmw;

#ifdef CONFIG_MFD_DP52_PMU
	int pmu_hwcontrol;
	struct mutex pmu_mutex;
#endif

#ifdef CONFIG_DEBUG_FS
	struct dentry *debugfs_root;
	struct dentry *debugfs_reg;
#endif
};

#ifdef CONFIG_MFD_DP52_PMU
int dp52_pmu_probe(struct device *dev, struct dp52_platform_data *pdata);
void dp52_pmu_remove(struct device *dev);
#else
static inline int dp52_pmu_probe(struct device *dev, struct dp52_platform_data *pdata)
{
	return 0;
}

static inline void dp52_pmu_remove(struct device *dev)
{
}
#endif

#endif
