/*
 * arch/arm/mach-dmw/css/coma-datahandler.h - DECT data handler character device
 *
 *  This driver registers one character device for each available data channel.
 *  It allows only one reader and one writer at the same time.
 *
 *  Copyright (C) 2007 NXP Semiconductors
 *  Copyright (C) 2008 - 2011 DSP Group Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef DATA_HANDLER_H
#define DATA_HANDLER_H

#include <linux/wait.h>
#include <linux/completion.h>
#include <linux/cdev.h>
#include "cmsg-datahandler.h"

#define MAX_HANDSET  10

struct dh_instance {
	int handset;
	int established;
	unsigned char bearer_type;
	unsigned char *buf;
	int command_status;
	wait_queue_head_t dh_read_compl;
	wait_queue_head_t dh_oper_compl;
	int len;
	union cmsg_datahandler_params dh_param;
};

typedef struct _datacall_info {
	int handset;
	unsigned char bearertype;
} DATACALL_INFO, *PDATACALL_INFO;
struct cordless_data_handler {
	dev_t dev;
	struct cdev cdev;
	int open_count;
	struct dh_instance *instances[MAX_HANDSET];
};

#define IOCTL_CORDLESS_DH_SET_HANDSET_AND_BEARERTYPE 0x0001
#define IOCTL_CORDLESS_DH_DISCONNECT_AIRLINK 0x0002

//void cordless_dh_data(int handset, int result, unsigned char *buf, int len);
int dh_set_status_established(int handset);
int datahandler_init(void);
void datahandler_exit(void);

#endif
