/*
 * arch/arm/mach-dmw/css/coma.h - the cordless manager
 *
 * The cordless manager is responsible for maintaining the main cfifo between
 * Linux and cordless which is used for loading and unloading cordless and for
 * registration of other services (e.g., debug output, VoIP/RTP, etc.)
 *
 * Copyright (C) 2007 NXP Semiconductors
 * Copyright (C) 2008 - 2011 DSP Group Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __COMA_H
#define __COMA_H

#include <linux/platform_device.h>

#include "cfifo.h"
#include "cmsg.h"
#include "coma-service.h"

struct coma_config {
	struct cfifo *fifo_c2l;
	struct cfifo *fifo_l2c;
	struct cfifo *fifo_l2c_phys;
	struct cfifo *fifo_c2l_phys; 
	struct cfifo *fifo_l2c_va;	/* used on CSS side only */
	struct cfifo *fifo_c2l_va;	/* used on CSS side only */
};

int cordless_initialized(void);

void coma_signal(int id);

/* Create a message to be sent over a cfifo to the cordless domain.
 * Parameters and payload are optional. */
int  coma_create_message(int id, int type,
                         void *params, unsigned int params_size,
                         unsigned char *payload, unsigned int payload_size);

/* Register the service with cordless in order to receive messages from and
 * send messages to the cordless domain. */
int  coma_register(int id, const char *name, 
		   struct cfifo *l2c, struct cfifo *c2l,
                   int (*process_message)(struct cmsg *cmsg),
                   int (*setup)(void), void (*remove)(void));
/* De-register the services (e.g., when unloading the corresponding kernel
 * module). */
int  coma_deregister(int id);

int  coma_init(int options, unsigned char *configuration,
               unsigned int config_len);
int  coma_deinit(void);
int  coma_timing(int options);

int  coma_setup(struct platform_device *pdev, struct cfifo *l2c, struct cfifo *c2l);
void coma_release(struct platform_device *pdev);

#endif
