/*
 * arch/arm/mach-dmw/include/mach/gpio.h
 *
 * DW GPIO wrappers for arch-neutral GPIO calls
 *
 * (c) 2011, DSP Group Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef __ASM_ARCH_DMW_GPIO_H
#define __ASM_ARCH_DMW_GPIO_H

#include <asm-generic/gpio.h>
#include <linux/dmw-gpio.h>

#define gpio_get_value __gpio_get_value
#define gpio_set_value __gpio_set_value
#define gpio_cansleep  __gpio_cansleep

extern int gpio_to_irq(unsigned gpio);
extern int irq_to_gpio(unsigned int irq);

extern void dmw_i2c_recover(unsigned scl, unsigned sda);

#endif /* __ASM_ARCH_DMW_GPIO_H */
