/*
 * dp52.h -- DP52 CODEC driver
 *
 *  Copyright (C) 2011 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __SND_SOC_CODEC_DP52_H_
#define __SND_SOC_CODEC_DP52_H_

#include <sound/soc.h>
#include <sound/soc-dai.h>


/* Clock divider Id's (enumeration) */
#define DP52_HQ_SD_CLKDIV_ID		0
#define DP52_LQ_SD_CLKDIV_ID		1
/* A.M.: Add other DP-52's audio-related(!) clock Dividers here.
 *       e.g. DSPDIV in reg CCR1, dividing FDSP (=='DP clk'),
 *       is Unrelated to the audio path, thus irrelevant here.
 */

/* PLL Id */
#define DP52_PLL_ID		0


extern struct snd_soc_dai dp52_dai;

extern struct snd_soc_codec_device soc_codec_dev_dp52;

/* Platform data structure to configure DP52 AFE */
struct dp52_codec_data {
	int some_config_param;
	int other_param;
};

#endif // __SND_SOC_CODEC_DP52_H_

