/************* COPYRIGHT AND CONFIDENTIALITY INFORMATION ********************
**                                                                         **
** Copyright (c) 2010 technicolor                                          **
** All Rights Reserved                                                     **
**                                                                         **
** This program contains proprietary information which is a trade          **
** secret of technicolor and/or its affiliates and also is protected as    **
** an unpublished work under applicable Copyright laws. Recipient is       **
** to retain this program in confidence and is not permitted to use or     **
** make copies thereof other than as permitted in a written agreement      **
** with technicolor, UNLESS OTHERWISE EXPRESSLY ALLOWED BY APPLICABLE LAWS.**
**                                                                         **
****************************************************************************/

/** \file
 * Multimedia connection generic netlink interface.
 *
 * \version v1.0
 *
 *************************************************************************/
#ifndef __MMCONN_NETLINK
#define __MMCONN_NETLINK

/*########################################################################
#                                                                       #
#  HEADER (INCLUDE) SECTION                                             #
#                                                                       #
########################################################################*/

/*########################################################################
#                                                                       #
#  MACROS/DEFINES                                                       #
#                                                                       #
########################################################################*/
#define MMCONN_GENL_FAMILY "MMCONN"  /**< Generic netlink family used for eventing. */
#define MMCONN_GENL_FAMILY_VERSION 1 /**< Version of Generic netlink family. */
#define MMCONN_EVENT_GROUP 0x01  /**< Generic netlink event group */
/*########################################################################
#                                                                       #
#  TYPES                                                                #
#                                                                       #
########################################################################*/

/**
 * Generic Netlink commands 
 */
enum {
	MMCONN_CMD_UNSPEC = 0,
	MMCONN_CMD_NOTIFY,  /**< Notification */
	__MMCONN_CMD_MAX,
};
#define MMCONN_CMD_MAX (__MMCONN_CMD_MAX - 1)  /**< Maximum number of commands */

/** 
 * Generic Netlink command attributes 
 */
enum {
	MMCONN_ATTR_UNSPEC = 0,
	MMCONN_ATTR_REF_MMCONN,       /**< Kernel space reference of MmConn */ 
	MMCONN_ATTR_EVENT,            /**< MmConnEvent */
	MMCONN_ATTR_EVENT_PARM,       /**< Optional parameter */
        __MMCONN_ATTR_MAX,
};
#define MMCONN_ATTR_MAX (__MMCONN_ATTR_MAX - 1)  /**< Maximum number of attributes */

#endif /*__MMCONN_NETLINK */
