/************* COPYRIGHT AND CONFIDENTIALITY INFORMATION ********************
**                                                                         **
** Copyright (c) 2010 technicolor                                          **
** All Rights Reserved                                                     **
**                                                                         **
** This program contains proprietary information which is a trade          **
** secret of technicolor and/or its affiliates and also is protected as    **
** an unpublished work under applicable Copyright laws. Recipient is       **
** to retain this program in confidence and is not permitted to use or     **
** make copies thereof other than as permitted in a written agreement      **
** with technicolor, UNLESS OTHERWISE EXPRESSLY ALLOWED BY APPLICABLE LAWS.**
**                                                                         **
****************************************************************************/

/** \file
 * Multimedia user connection generic netlink private API.
 *
 * \version v1.0
 *
 *************************************************************************/
#ifndef __MMCONNUSR_NETLINK_P
#define __MMCONNUSR_NETLINK_P

/*########################################################################
#                                                                       #
#  HEADER (INCLUDE) SECTION                                             #
#                                                                       #
########################################################################*/
#include "mmconnuser_netlink.h"
#include "mmconn_p.h"
#include "mmcommon.h"
/*########################################################################
#                                                                       #
#  MACROS/DEFINES                                                       #
#                                                                       #
########################################################################*/


/*########################################################################
#                                                                       #
#  TYPES                                                                #
#                                                                       #
########################################################################*/

/*########################################################################
#                                                                       #
#  FUNCTION PROTOTYPES                                                  #
#                                                                       #
########################################################################*/
MmPbxError mmConnUsrGeNlSetTraceLevel(MmPbxTraceLevel level);
MmPbxError mmConnUsrGeNlInit(void);
MmPbxError mmConnUsrGeNlDeinit(void);
MmPbxError mmConnUsrGeNlCreateFam(MmConnUsrHndl mmConnUsr);
MmPbxError mmConnUsrGeNlDestroyFam(MmConnUsrHndl mmConnUsr);
MmPbxError mmConnUsrGeNlWrite(MmConnUsrHndl      mmConnUsr,
                              MmConnPacketHeader *header,
                              unsigned char      *buff,
                              unsigned int       bytes);

#endif /* __MMCONNUSR_NETLINK_P */
