/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.internal.Factory;
import org.gradle.internal.featurelifecycle.DeprecatedFeatureUsage;
import org.gradle.internal.featurelifecycle.DeprecatedUsageBuildOperationProgressBroadaster;
import org.gradle.internal.featurelifecycle.FeatureHandler;
import org.gradle.internal.featurelifecycle.FeatureUsage;
import org.gradle.internal.featurelifecycle.IncubatingFeatureUsage;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.LoggingIncubatingFeatureHandler;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;

@ThreadSafe
public class SingleMessageLogger {
    private static final ThreadLocal<Boolean> ENABLED = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    public static final String INCUBATION_MESSAGE = "%s is an incubating feature.";
    private static LoggingDeprecatedFeatureHandler deprecatedFeatureHandler = new LoggingDeprecatedFeatureHandler();
    private static LoggingIncubatingFeatureHandler incubatingFeatureHandler = new LoggingIncubatingFeatureHandler();

    public static synchronized void reset() {
        deprecatedFeatureHandler.reset();
        incubatingFeatureHandler.reset();
    }

    public static synchronized void init(UsageLocationReporter reporter, WarningMode warningMode, DeprecatedUsageBuildOperationProgressBroadaster buildOperationProgressBroadaster) {
        deprecatedFeatureHandler.init(reporter, warningMode, buildOperationProgressBroadaster);
    }

    public static synchronized void reportSuppressedDeprecations() {
        deprecatedFeatureHandler.reportSuppressedDeprecations();
    }

    public static void nagUserOfReplacedPlugin(String pluginName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s plugin %s has been deprecated.", pluginName), LoggingDeprecatedFeatureHandler.getRemovalDetails(), String.format("Please use the %s plugin instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfPluginReplacedWithExternalOne(String pluginName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s plugin has been deprecated.", pluginName), LoggingDeprecatedFeatureHandler.getRemovalDetails(), String.format("Consider using the %s plugin instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfToolReplacedWithExternalOne(String toolName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s has been deprecated.", toolName), SingleMessageLogger.thisWillBeRemovedMessage(), String.format("Consider using %s instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfReplacedTask(String taskName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s task has been deprecated.", taskName), SingleMessageLogger.thisWillBeRemovedMessage(), String.format("Please use the %s task instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfReplacedTaskType(String taskName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s task type has been deprecated.", taskName), SingleMessageLogger.thisWillBeRemovedMessage(), String.format("Please use the %s instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfReplacedMethod(String methodName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method has been deprecated.", methodName), SingleMessageLogger.thisWillBeRemovedMessage(), String.format("Please use the %s method instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfReplacedMethodWithCustomRemoval(String methodName, String replacement, String removalDetails) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method has been deprecated.", methodName), removalDetails, String.format("Please use the %s method instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfReplacedProperty(String propertyName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s property has been deprecated.", propertyName), SingleMessageLogger.thisWillBeRemovedMessage(), String.format("Please use the %s property instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDiscontinuedMethod(String methodName) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method has been deprecated.", methodName), SingleMessageLogger.thisWillBeRemovedMessage(), null, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDiscontinuedMethod(String methodName, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method has been deprecated.", methodName), SingleMessageLogger.thisWillBeRemovedMessage(), advice, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDiscontinuedMethod(String methodName, String advice, String contextualAdvice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method has been deprecated.", methodName), SingleMessageLogger.thisWillBeRemovedMessage(), advice, contextualAdvice, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDiscontinuedProperty(String propertyName, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s property has been deprecated.", propertyName), SingleMessageLogger.thisWillBeRemovedMessage(), advice, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDiscontinuedApi(String api, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s has been deprecated.", api), SingleMessageLogger.thisWillBeRemovedMessage(), advice, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfReplacedNamedParameter(String parameterName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s named parameter has been deprecated.", parameterName), SingleMessageLogger.thisWillBeRemovedMessage(), String.format("Please use the %s named parameter instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserWithDeprecatedIndirectUserCodeCause(String summary) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWithDeprecatedIndirectUserCodeCause(summary, null);
        }
    }

    public static void nagUserWithDeprecatedBuildInvocationFeature(String summary, String advice) {
        SingleMessageLogger.nagUserWithDeprecatedBuildInvocationFeature(summary, SingleMessageLogger.thisWillBeRemovedMessage(), advice);
    }

    public static void nagUserWithDeprecatedBuildInvocationFeature(String summary, String removalDetails, String advice) {
        SingleMessageLogger.nagUserWith(String.format("%s has been deprecated.", summary), removalDetails, advice, null, DeprecatedFeatureUsage.Type.BUILD_INVOCATION);
    }

    public static void nagUserWithDeprecatedIndirectUserCodeCause(String summary, @Nullable String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWithDeprecatedIndirectUserCodeCause(summary, advice, null);
        }
    }

    public static void nagUserWithDeprecatedIndirectUserCodeCause(String summary, @Nullable String advice, @Nullable String contextualAdvice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("%s has been deprecated.", summary), SingleMessageLogger.thisWillBeRemovedMessage(), advice, contextualAdvice, DeprecatedFeatureUsage.Type.USER_CODE_INDIRECT);
        }
    }

    public static void nagUserWithDeprecatedIndirectUserCodeCause(String summary, String removalDetails, String advice, String contextualAdvice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("%s has been deprecated.", summary), removalDetails, advice, contextualAdvice, DeprecatedFeatureUsage.Type.USER_CODE_INDIRECT);
        }
    }

    @VisibleForTesting
    static void nagUserWith(String summary) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(summary, null);
        }
    }

    public static void nagUserWith(String message, @Nullable String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(message, SingleMessageLogger.thisWillBeRemovedMessage(), advice, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserWith(String summary, String removalDetails, String advice, String contextualAdvice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(deprecatedFeatureHandler, new DeprecatedFeatureUsage(summary, removalDetails, advice, contextualAdvice, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT, SingleMessageLogger.class));
        }
    }

    public static void nagUserWith(String summary, String removalDetails, @Nullable String advice, @Nullable String contextualAdvice, DeprecatedFeatureUsage.Type usageType) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(deprecatedFeatureHandler, new DeprecatedFeatureUsage(summary, removalDetails, advice, contextualAdvice, usageType, SingleMessageLogger.class));
        }
    }

    private static synchronized <T extends FeatureUsage> void nagUserWith(FeatureHandler<T> handler, T usage) {
        handler.featureUsed(usage);
    }

    public static void nagUserOfDeprecated(String thing) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("%s has been deprecated.", thing), SingleMessageLogger.thisWillBeRemovedMessage(), null, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDeprecated(String thing, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("%s has been deprecated.", thing), SingleMessageLogger.thisWillBeRemovedMessage(), advice, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDeprecatedBehaviour(String behaviour) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(behaviour, String.format("This behaviour has been deprecated and %s", LoggingDeprecatedFeatureHandler.getRemovalDetails()), null, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDeprecatedThing(String thing) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(thing, String.format("This has been deprecated and %s", LoggingDeprecatedFeatureHandler.getRemovalDetails()), null, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDeprecatedThing(String thing, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(thing, String.format("This has been deprecated and %s", LoggingDeprecatedFeatureHandler.getRemovalDetails()), advice, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T whileDisabled(Factory<T> factory) {
        ENABLED.set(false);
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            ENABLED.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void whileDisabled(Runnable action) {
        ENABLED.set(false);
        try {
            action.run();
        }
        finally {
            ENABLED.set(true);
        }
    }

    private static boolean isEnabled() {
        return ENABLED.get();
    }

    private static String thisWillBeRemovedMessage() {
        return String.format("This %s", LoggingDeprecatedFeatureHandler.getRemovalDetails());
    }

    public static void incubatingFeatureUsed(String incubatingFeature) {
        SingleMessageLogger.nagUserWith(incubatingFeatureHandler, new IncubatingFeatureUsage(incubatingFeature, SingleMessageLogger.class));
    }
}

