/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitution;
import org.gradle.internal.component.model.DependencyMetadata;

public interface DependencySubstitutionApplicator {
    public static final DependencySubstitutionApplicator NO_OP = new DependencySubstitutionApplicator(){

        @Override
        public SubstitutionResult apply(DependencyMetadata dependency) {
            return SubstitutionResult.of(new DefaultDependencySubstitution(dependency.getSelector(), dependency.getReason()));
        }
    };

    public SubstitutionResult apply(DependencyMetadata var1);

    public static class SubstitutionResult {
        private final DependencySubstitutionInternal result;
        private final Throwable failure;

        private SubstitutionResult(DependencySubstitutionInternal result, Throwable failure) {
            this.result = result;
            this.failure = failure;
        }

        public static SubstitutionResult of(DependencySubstitutionInternal details) {
            return new SubstitutionResult(details, null);
        }

        public static SubstitutionResult failed(Throwable err) {
            return new SubstitutionResult(null, err);
        }

        public DependencySubstitutionInternal getResult() {
            return this.result;
        }

        public Throwable getFailure() {
            return this.failure;
        }

        public boolean hasFailure() {
            return this.failure != null;
        }
    }
}

