/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.charabia.jsmoothgen.application.gui.util.FileSelectionTextField;
import net.charabia.jsmoothgen.application.gui.util.HTMLPane;
import net.charabia.jsmoothgen.application.gui.util.PanelLayout;

public class OptionalHelpPanel
extends JPanel {
    private JPanel m_panel = new JPanel();
    protected boolean m_limitHeight = true;
    private HTMLPane m_helpPanel = new HTMLPane(){

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (OptionalHelpPanel.this.m_limitHeight && d.height > 180) {
                d.height = 180;
            }
            return d;
        }
    };
    private JPanel m_titlePanel = new JPanel();
    private JLabel m_title = new JLabel();
    private JButton m_helptoggle = new JButton("?");
    private boolean m_helpActive = false;

    public OptionalHelpPanel() {
        this.setLayout(new GridBagLayout());
        this.m_helptoggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionalHelpPanel.this.m_helpActive = !OptionalHelpPanel.this.m_helpActive;
                OptionalHelpPanel.this.toggleHelpCheck();
            }
        });
        this.setLayout(new PanelLayout());
        this.m_titlePanel.setLayout(new BorderLayout());
        this.m_titlePanel.add("Center", this.m_title);
        this.m_titlePanel.add("East", this.m_helptoggle);
        this.m_titlePanel.setOpaque(true);
        this.m_helptoggle.setOpaque(false);
        this.m_helptoggle.setBorder(null);
        this.m_title.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 2));
        this.add(this.m_titlePanel);
        this.add(this.m_panel);
        this.add(this.m_helpPanel);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createBevelBorder(0)), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        URL helpimgurl = this.getClass().getResource("/icons/stock_help-agent.png");
        if (helpimgurl != null) {
            ImageIcon leaf = new ImageIcon(helpimgurl);
            this.m_helptoggle.setIcon(leaf);
            this.m_helptoggle.setText("");
        } else {
            this.m_helptoggle.setText("(?)");
        }
        this.setLabelColor(Color.white, Color.darkGray);
        this.toggleHelpCheck();
    }

    private void toggleHelpCheck() {
        this.m_helpPanel.setVisible(this.m_helpActive);
        this.validate();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = 1;
        return d;
    }

    public JPanel getContentPane() {
        return this.m_panel;
    }

    public void setLabel(String label) {
        label = "<html><b>" + label + "</b></hmtl>";
        this.m_title.setText(label);
    }

    public void setHelpText(String help) {
        this.m_helpPanel.setText(help);
    }

    public void setLabelColor(Color fore, Color back) {
        this.m_titlePanel.setBackground(back);
        this.m_title.setForeground(fore);
        this.repaint();
    }

    public void setLimitHeight(boolean b) {
        this.m_limitHeight = b;
        this.validate();
        this.repaint();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("test");
        OptionalHelpPanel ohp = new OptionalHelpPanel();
        ohp.setHelpText("This is my help text");
        ohp.setLabel("My label1");
        ohp.getContentPane().setLayout(new BorderLayout());
        ohp.getContentPane().add("Center", new FileSelectionTextField());
        OptionalHelpPanel ohp2 = new OptionalHelpPanel();
        ohp.setLabel("hop2");
        ohp2.setHelpText("<html><h1>This is my second help text</h1>le g\u00e9ant du logiciel va-t-il \u00e9couter et arr\u00eater le d\u00e9luge promotionel qui vise \u00e0 faire connaitre les nouveaut\u00e9s de Office 2003 alors que les utilisateurs sont satisfaits des versions pr\u00e9c\u00e9dentes et que les responsables zieutent lourdement du cot\u00e9 de Linux et d'OpenOffice ?");
        ohp2.getContentPane().setLayout(new BorderLayout());
        ohp2.getContentPane().add("Center", new JTextField());
        f.getContentPane().setLayout(new PanelLayout());
        f.getContentPane().add(ohp);
        f.getContentPane().add(ohp2);
        f.setSize(300, 300);
        f.setVisible(true);
    }
}

