/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Hashtable;
import net.charabia.jsmoothgen.application.gui.util.LayoutLengthDescriptor;

public class PanelLayout
implements LayoutManager {
    private Dimension m_minimumSize;
    private Hashtable m_componentToLayoutLengthDescriptor = new Hashtable();

    public void addLayoutComponent(String name, Component comp) {
        LayoutLengthDescriptor ld = new LayoutLengthDescriptor(name);
        this.m_componentToLayoutLengthDescriptor.put(comp, ld);
    }

    public void removeLayoutComponent(Component comp) {
        this.m_componentToLayoutLengthDescriptor.remove(comp);
    }

    private void calculateMinimumSize(Container parent) {
        this.m_minimumSize = new Dimension();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component element = parent.getComponent(i);
            if (!element.isVisible()) continue;
            Dimension eld = element.getPreferredSize();
            LayoutLengthDescriptor ld = (LayoutLengthDescriptor)this.m_componentToLayoutLengthDescriptor.get(element);
            if (ld != null) {
                eld.height = ld.getLength(parent.getHeight());
            }
            this.m_minimumSize.height += eld.height;
            this.m_minimumSize.width = Math.max(this.m_minimumSize.width, eld.width);
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    public Dimension minimumLayoutSize(Container parent) {
        this.calculateMinimumSize(parent);
        Dimension dim = new Dimension(this.m_minimumSize);
        Insets insets = parent.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int xoffset = insets.left;
        int yoffset = insets.top;
        int maxcwidth = parent.getWidth() - (insets.right + insets.left);
        int maxcheight = parent.getHeight() - insets.bottom;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component element = parent.getComponent(i);
            if (!element.isVisible()) continue;
            Dimension eld = element.getPreferredSize();
            LayoutLengthDescriptor ld = (LayoutLengthDescriptor)this.m_componentToLayoutLengthDescriptor.get(element);
            if (ld != null) {
                eld.height = ld.getLength(parent.getHeight());
            }
            if (eld.height + yoffset > maxcheight) {
                eld.height = maxcheight - yoffset;
            }
            element.setBounds(xoffset, yoffset, maxcwidth, eld.height);
            yoffset += eld.height;
        }
    }
}

